% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree_C5.0.R
\name{details_boost_tree_C5.0}
\alias{details_boost_tree_C5.0}
\title{Boosted trees via C5.0}
\description{
\code{\link[C50:C5.0]{C50::C5.0()}} creates a series of classification trees forming an
ensemble. Each tree depends on the results of previous trees. All trees in
the ensemble are combined to produce a final prediction.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{trees}: # Trees (type: integer, default: 15L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 2L)
\item \code{sample_size}: Proportion Observations Sampled (type: double,
default: 1.0)
}

The implementation of C5.0 limits the number of trees to be between 1
and 100.
}

\subsection{Translation from parsnip to the original package (classification)}{\if{html}{\out{<div class="r">}}\preformatted{boost_tree(trees = integer(), min_n = integer(), sample_size = numeric()) \%>\% 
  set_engine("C5.0") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Boosted Tree Model Specification (classification)
## 
## Main Arguments:
##   trees = integer()
##   min_n = integer()
##   sample_size = numeric()
## 
## Computational engine: C5.0 
## 
## Model fit template:
## parsnip::C5.0_train(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     trials = integer(), minCases = integer(), sample = numeric())
}

\code{\link[=C5.0_train]{C5.0_train()}} is a wrapper around
\code{\link[C50:C5.0]{C50::C5.0()}} that makes it easier to run this model.
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Other details}{
\subsection{Early stopping}{

By default, early stopping is used. To use the complete set of boosting
iterations, pass \code{earlyStopping = FALSE} to
\code{\link[=set_engine]{set_engine()}}. Also, it is unlikely that early
stopping will occur if \code{sample_size = 1}.
}

}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#boost-tree-C5.0}{examples}
for \code{boost_tree()} with the \code{"C5.0"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
