% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg.R
\name{logistic_reg}
\alias{logistic_reg}
\alias{update.logistic_reg}
\title{General Interface for Logistic Regression Models}
\usage{
logistic_reg(mode = "classification", penalty = NULL, mixture = NULL)

\method{update}{logistic_reg}(object, penalty = NULL, mixture = NULL,
  fresh = FALSE, ...)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "classification".}

\item{penalty}{An non-negative number representing the total
amount of regularization (\code{glmnet}, \code{keras}, and \code{spark} only).
For \code{keras} models, this corresponds to purely L2 regularization
(aka weight decay) while the other models can be a combination
of L1 and L2 (depending on the value of \code{mixture}).}

\item{mixture}{A number between zero and one (inclusive) that
represents the proportion of regularization that is used for the
L2 penalty (i.e. weight decay, or ridge regression) versus L1
(the lasso) (\code{glmnet} and \code{spark} only).}

\item{object}{A logistic regression model specification.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{logistic_reg()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R, Stan, keras, or via Spark. The main
arguments for the model are:
\itemize{
\item \code{penalty}: The total amount of regularization
in the model. Note that this must be zero for some engines.
\item \code{mixture}: The proportion of L1 regularization in
the model. Note that this will be ignored for some engines.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
For \code{logistic_reg()}, the mode will always be "classification".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"glm"} or \code{"glmnet"}
\item \pkg{Stan}:  \code{"stan"}
\item \pkg{Spark}: \code{"spark"}
\item \pkg{keras}: \code{"keras"}
}
}
\note{
For models created using the spark engine, there are
several differences to consider. First, only the formula
interface to via \code{fit()} is available; using \code{fit_xy()} will
generate an error. Second, the predictions will always be in a
spark table format. The names will be the same as documented but
without the dots. Third, there is no equivalent to factor
columns in spark tables so class predictions are returned as
character columns. Fourth, to retain the model object for a new
R session (via \code{save()}), the \code{model$fit} element of the \code{parsnip}
object should be serialized via \code{ml_save(object$fit)} and
separately saved to disk. In a new session, the object can be
reloaded and reattached to the \code{parsnip} object.
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call.  For this type of
model, the template of the fit calls are:

\pkg{glm}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::logistic_reg(), "glm")}

\pkg{glmnet}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::logistic_reg(), "glmnet")}

\pkg{stan}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::logistic_reg(), "stan")}

\pkg{spark}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::logistic_reg(), "spark")}

\pkg{keras}

\Sexpr[results=rd]{parsnip:::show_fit(parsnip:::logistic_reg(), "keras")}

When using \code{glmnet} models, there is the option to pass
multiple values (or no values) to the \code{penalty} argument. This
can have an effect on the model object results. When using the
\code{predict()} method in these cases, the return value depends on
the value of \code{penalty}. When using \code{predict()}, only a single
value of the penalty can be used. When predicting on multiple
penalties, the \code{multi_predict()} function can be used. It
returns a tibble with a list column called \code{.pred} that contains
a tibble with all of the penalty results.

For prediction, the \code{stan} engine can compute posterior
intervals analogous to confidence and prediction intervals. In
these instances, the units are the original outcome and when
\code{std_error = TRUE}, the standard deviation of the posterior
distribution (or posterior predictive distribution as
appropriate) is returned. For \code{glm}, the standard error is in logit units
while the intervals are in probability units.
}

\examples{
logistic_reg()
# Parameters can be represented by a placeholder:
logistic_reg(penalty = varying())
model <- logistic_reg(penalty = 10, mixture = 0.1)
model
update(model, penalty = 1)
update(model, penalty = 1, fresh = TRUE)
}
\seealso{
\code{\link[=varying]{varying()}}, \code{\link[=fit]{fit()}}
}
