% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_chunk_options.R
\name{chunk_options}
\alias{chunk_options}
\alias{rmd_set_options}
\alias{rmd_get_options}
\title{Get and set code chunk options}
\usage{
rmd_set_options(x, ...)

rmd_get_options(x, ..., defaults = list())
}
\arguments{
\item{x}{An \code{rmd_ast}, \code{rmd_tibble}, or any rmd ast node object.}

\item{...}{Either a collection of named values for the setter or a character values
of the option names for the getter.}

\item{defaults}{A named list of default values for the options.}
}
\value{
\code{rmd_set_options} returns the modified version of the original object.

\code{rmd_get_options} returns a list of the requested options (or all options if none
are specified). Non-chunk nodes return \code{NULL}.
}
\description{
Helper functions for obtaining or changing chunk options
within an rmd object.
}
\examples{
rmd = parse_rmd(system.file("minimal.Rmd", package = "parsermd"))

str(rmd_get_options(rmd))
str(rmd_get_options(rmd), "include")

rmd_set_options(rmd, include = TRUE)

}
