% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.data.frame.R
\name{standardize.data.frame}
\alias{standardize.data.frame}
\title{Data Standardization (Z-scores)}
\usage{
\method{standardize}{data.frame}(x, robust = FALSE, method = "default",
  select = NULL, exclude = NULL, verbose = TRUE, force = FALSE,
  ...)
}
\arguments{
\item{x}{Object.}

\item{robust}{Logical, if \code{TRUE}, centering is done by substracting the
median from the variables and divide it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by substracting the
mean and divide it by the standard deviation (SD).
the}

\item{method}{The method of standardization. For data.frames, can be \code{"default"} (variables are divided by SD or MAD depending on \code{robust}) or \code{"2sd"} (divided by two times the deviation).}

\item{select}{For a data frame, character vector of column names to be
standardized. If \code{NULL} (the default), all variables will be
standardized.}

\item{exclude}{For a data frame, character vector of column names to
be excluded from standardization.}

\item{verbose}{Toggle warnings on or off.}

\item{force}{Logical, if \code{TRUE}, forces standardization of factors as
well. Factors are converted to numerical values, with the lowest level
being the value \code{1} (unless the factor has numeric levels, which are
converted to the corresponding numeric value).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A standardized data.frame.
}
\description{
Standardize (centering and scaling, Z-score) the data so that the
  values are expressed in terms of standard deviation (i.e., mean = 0, SD = 1)
  or Median Absolute Deviance (median = 0, MAD = 1). A \code{normalization}
  scales all numeric variables in the 0 - 1 range.
}
\examples{
summary(standardize(iris))
}
