% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setHistoVisibility}
\alias{setHistoVisibility}
\title{Histograms visibility}
\usage{
setHistoVisibility(id, histoVisibility)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{histoVisibility}{Vector of boolean (one for each data column), \code{TRUE} if an histogram must be displayed;
\code{NULL} is allowed, meaning no histogram must be displayed.
A named list can also be provided to only indicate which columns must be assigned to a new display.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which columns have to be displayed with histograms.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       checkboxInput("histCB", "Histogram Visibility", FALSE),
       p("The check box controls the visibility of histograms"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(iris)
       })
       observeEvent(input$histCB, {
           histoVisibility <- rep(input$histCB, ncol(iris))
           parallelPlot::setHistoVisibility("parPlot", histoVisibility)
       })
   }

   shinyApp(ui, server)
 }

}
