% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setCategoricalColorScale}
\alias{setCategoricalColorScale}
\title{Traces colors}
\usage{
setCategoricalColorScale(id, categoricalCsId)
}
\arguments{
\item{id}{output variable to read from (id which references the requested plot)}

\item{categoricalCsId}{one of the available color scale ids}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which color scale to use when reference column is of type categorical.
}
\details{
If a column is defined as the reference (for example by clicking on its header), a color scale is associated to this column.
Available color scale ids are: `Category10`, `Accent`, `Dark2`, `Paired`, `Set1`.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
       selectInput("categoricalCsSelect", "Categorical Color Scale:", 
           choices = list("Category10" = "Category10", "Accent" = "Accent", "Dark2" = "Dark2", 
                           "Paired" = "Paired", "Set1" = "Set1"), selected = "Category10"),
       p("The selector controls the colors used when reference column is of type categorical"),
       parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(data = iris, refColumnDim = "Species")
       })
       observeEvent(input$categoricalCsSelect, {
           parallelPlot::setCategoricalColorScale("parPlot", input$categoricalCsSelect)
       })
   }

   shinyApp(ui, server)
 }

}
