% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_design_grid.R
\name{generate_design_grid}
\alias{generate_design_grid}
\title{Generate a Grid Design}
\usage{
generate_design_grid(param_set, resolution = NULL, param_resolutions = NULL)
}
\arguments{
\item{param_set}{(\code{\link{ParamSet}}).}

\item{resolution}{(\code{integer(1)})\cr
Global resolution for all parameters.}

\item{param_resolutions}{(named \code{integer()})\cr
Resolution per \code{\link{Domain}}, named by parameter ID.}
}
\value{
\code{\link{Design}}.
}
\description{
Generate a grid with a specified resolution in the parameter space.
The resolution for categorical parameters is ignored, these parameters
always produce a grid over all their valid levels.
For number params the endpoints of the params are always included in the grid.
}
\examples{
pset = ps(
  ratio = p_dbl(lower = 0, upper = 1),
  letters = p_fct(levels = letters[1:3])
)
generate_design_grid(pset, 10)
}
\seealso{
Other generate_design: 
\code{\link{generate_design_lhs}()},
\code{\link{generate_design_random}()},
\code{\link{generate_design_sobol}()}
}
\concept{generate_design}
