% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sampler1D.R
\name{Sampler1DRfun}
\alias{Sampler1DRfun}
\title{Sampler1DRfun Class}
\description{
Arbitrary sampling from 1D RNG functions from R.
}
\seealso{
Other Sampler: 
\code{\link{Sampler}},
\code{\link{Sampler1D}},
\code{\link{Sampler1DCateg}},
\code{\link{Sampler1DNormal}},
\code{\link{Sampler1DUnif}},
\code{\link{SamplerHierarchical}},
\code{\link{SamplerJointIndep}},
\code{\link{SamplerUnif}}
}
\concept{Sampler}
\section{Super classes}{
\code{\link[paradox:Sampler]{paradox::Sampler}} -> \code{\link[paradox:Sampler1D]{paradox::Sampler1D}} -> \code{Sampler1DRfun}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rfun}}{(\verb{function()})\cr
Random number generator function.}

\item{\code{trunc}}{(\code{logical(1)})\cr
\code{TRUE} enables naive rejection sampling, so we stay inside of [lower, upper].}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Sampler1DRfun-new}{\code{Sampler1DRfun$new()}}
\item \href{#method-Sampler1DRfun-clone}{\code{Sampler1DRfun$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="paradox" data-topic="Sampler" data-id="format"><a href='../../paradox/html/Sampler.html#method-Sampler-format'><code>paradox::Sampler$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="Sampler" data-id="print"><a href='../../paradox/html/Sampler.html#method-Sampler-print'><code>paradox::Sampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="Sampler" data-id="sample"><a href='../../paradox/html/Sampler.html#method-Sampler-sample'><code>paradox::Sampler$sample()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Sampler1DRfun-new"></a>}}
\if{latex}{\out{\hypertarget{method-Sampler1DRfun-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sampler1DRfun$new(param, rfun, trunc = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{(\code{\link{ParamSet}})\cr
Domain / support of the distribution we want to sample from.
Must be one-dimensional.}

\item{\code{rfun}}{(\verb{function()})\cr
Random number generator function, e.g. \code{rexp} to sample from exponential distribution.}

\item{\code{trunc}}{(\code{logical(1)})\cr
\code{TRUE} enables naive rejection sampling, so we stay inside of [lower, upper].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Sampler1DRfun-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Sampler1DRfun-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sampler1DRfun$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
