% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_methods.R
\name{summary.panel_data}
\alias{summary.panel_data}
\title{Summarize panel data frames}
\usage{
\method{summary}{panel_data}(object, ..., by.wave = TRUE, by.id = FALSE, skim_with = NULL)
}
\arguments{
\item{object}{A \code{panel_data} frame.}

\item{...}{Optionally, unquoted variable names/expressions separated by
commas to be passed to \code{\link[dplyr:select]{dplyr::select()}}. Otherwise, all columns are
included.}

\item{by.wave}{(if \code{skimr} is installed) Separate descriptives by wave?
Default is TRUE.}

\item{by.id}{(if \code{skimr} is installed) Separate descriptives by entity?
Default is FALSE. Be careful if you have a large number of entities as
the output will be massive.}

\item{skim_with}{A closure from \code{\link[skimr:skim_with]{skimr::skim_with()}}. If set, skim}
}
\description{
\code{summary} method for \code{panel_data} objects.
}
\examples{

data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
summary(wages, lwage, exp, wks)

}
