% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffs.R
\name{make_diff_data}
\alias{make_diff_data}
\title{Generate differenced and asymmetric effects data}
\usage{
make_diff_data(formula, data, id = NULL, wave = NULL,
  use.wave = FALSE, min.waves = 1, weights = NULL, offset = NULL,
  asym = FALSE, cumulative = FALSE, escape.names = FALSE, ...)
}
\arguments{
\item{formula}{Model formula. See details for crucial
info on \code{panelr}'s formula syntax.}

\item{data}{The data, either a \code{panel_data} object or \code{data.frame}.}

\item{id}{If \code{data} is not a \code{panel_data} object, then the name of the
individual id column as a string. Otherwise, leave as NULL, the default.}

\item{wave}{If \code{data} is not a \code{panel_data} object, then the name of the
panel wave column as a string. Otherwise, leave as NULL, the default.}

\item{use.wave}{Should the wave be included as a predictor? Default is
FALSE.}

\item{min.waves}{What is the minimum number of waves an individual must
have participated in to be included in the analysis? Default is \code{2} and
any valid number is accepted. \code{"all"} is also acceptable if you want to
include only complete panelists.}

\item{weights}{If using weights, either the name of the column in the data
that contains the weights or a vector of the weights.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during
    fitting. This should be \code{NULL} or a numeric vector of length
    equal to the number of cases.  One or more \code{\link{offset}}
    terms can be included in the formula instead or as well, and if more
    than one is specified their sum is used.  See \code{\link{model.offset}}.}

\item{asym}{Return asymmetric effects transformed data? Default is FALSE.}

\item{cumulative}{Return cumulative positive/negative differences, most
useful for fixed effects estimation and/or generalized linear models?
Default is FALSE.}

\item{escape.names}{Return only syntactically valid variable names?
Default is FALSE.}

\item{...}{Ignored.}
}
\description{
This is an interface to the internal functions that process data for
\code{\link[=fdm]{fdm()}}, \code{\link[=asym]{asym()}}, and \code{\link[=asym_gee]{asym_gee()}}.
}
\examples{

data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
make_diff_data(wks ~ lwage + union, data = wages)
 
}
