\name{plot.EAMM}
\alias{plot.EAMM}

\title{ Graphic output of the EAMM function }
\description{
  provide graphic interpretation of the simulation results
}

\usage{
\method{plot}{EAMM}(x, graphtype = "both", vi, vs, fun3D="wireframe", \dots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ an EAMM object }
  \item{graphtype}{ "VI", "VS", or "both"
    "VI" give graphs with varying variance component of intercept and
    with a fixed variance component for slope specified in vs argument
    "VS" give graphs with varying variance component for slope and with a
    fixed variance component of intercept specified in vi argument
    "both" 3-D plot see also fun3D argument
    }
  \item{vi}{ VI for which plots the output. Necessary for "VS" type of graph }
  \item{vs}{ VS for which plots the output. Necessary for "VI" type of graph }
  \item{fun3D}{plot function used to plot the 3D graph.
  	"wireframe" uses lattice,
  	"persp" uses  graphics,
  	and "open3d" uses rgl.}
  \item{\dots}{ potentially further arguments to pass to methods }
}

\author{ Julien Martin }

\seealso{\code{\link{EAMM}}, \code{\link{plot.PAMM}}, \code{\link{plot.SSF}} }
\examples{
\dontrun{
  ours <- EAMM(numsim=10, group=10, repl=4,
               VI=seq(0.1,0.95,0.05), VS=c(0.05,0.1) )
  plot(ours, "both")
  plot(ours, "VI",vs=0.1)
  plot(ours,"VS",vi=0.2)
   }
}

\keyword{ misc }
