% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_querys.R
\name{pbdb_occurrence}
\alias{pbdb_occurrence}
\title{pbdb_occurrence}
\usage{
pbdb_occurrence (id, ...)
}
\arguments{
\item{id}{identifier of the occurrence. This parameter is required}

\item{...}{arguments passed to the API. See all available arguments in
\url{http://paleobiodb.org/data1.1/occs/single}. Eg:
\itemize{
 \item \emph{vocab}: set vocab="pbdb" to show the complete name of the variables (by
   default variables have short 3-letter names)
}}
}
\value{
a dataframe with a single occurrence
}
\description{
Returns information about a single occurrence record from the Paleobiology 
Database.
}
\details{
Documentation for all the parameters is available at 
http://paleobiodb.org/data1.1/occs/single. In the parameter list above, we
describe the most common filters that paleontologists and ecologists might
use.
}
\examples{
\dontrun{
pbdb_occurrence (id=1001)
pbdb_occurrence (id=1001, vocab="pbdb", show="coords")
}
}

