% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{divdistr_int}
\alias{divdistr_int}
\title{Count number of taxon records overlapping a specific time interval.}
\usage{
divdistr_int(x, table = NULL, ids = FALSE, max = table$max, min = table$min)
}
\arguments{
\item{x}{A numeric vector of length 2 specifying the start and end (in ma) of the time interval in question.}

\item{table}{Taxon-range table to use}

\item{ids}{Logical whether to return ids of entries in taxon-range table (defaults to FALSE) or their number}

\item{max}{Vector or column containing the maximum age of each entry in the taxon-range table. Defaults to table$max}

\item{min}{Vector or column containing the minimum age of each entry in the taxon-range table. Defaults to table$min}
}
\value{
A single numeric giving the number of entries in table overlapping the specified interval, or a numeric vector giving their indices.
}
\description{
Count number of taxon records overlapping a specific time interval.
}
\examples{
data(archosauria)
divdistr_int(x=c(201,220), table=archosauria$sptab_Coelophysoidea)
}
