% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{viol}
\alias{viol}
\title{Generate a violin plot}
\usage{
viol(
  x,
  pos,
  x2 = NULL,
  stat = density,
  dscale = 1,
  cutoff = range(x),
  horiz = TRUE,
  add = TRUE,
  lim = cutoff,
  xlab = "",
  ylab = "",
  fill = "grey",
  col = "black",
  lwd = 1,
  lty = 1,
  ...
)
}
\arguments{
\item{x}{Variable for which to plot violin.}

\item{pos}{Position at which to place violin in the axis perpendicular to x}

\item{x2}{Optional variable to use instead of x as input variable for the violin plot. If x2 is set, the function (default: density()) used to calculate the plotting statistic is run on x2 instead of x, but the results are plotted at the corresponding x values.}

\item{stat}{The plotting statistic. Details to the density() function, as in a standard violin plot, but can be overridden with another function that can take x or x2 as its first argument. Stat can also be a numeric vector of the same length as x, in which case the values in this vectors are used instead of the function output and plotted against x as an independent variable.}

\item{dscale}{The scale to apply to the values for density (or another plotting statistic). Defaults to 1, but adjustment may be needed depending on the scale of the plot the violin is to be added to.}

\item{cutoff}{Setting for cropping the violin. Can be either a single value, in which case the input is interpreted as number of standard deviations from the mean, or a numeric vector of length 2, giving the lower and upper cutoff value directly.}

\item{horiz}{Logical indicating whether to plot horizontally (defaults to TRUE) or vertically}

\item{add}{Logical indicating whether to add to an existing plot (defaults to TRUE) or generate a new plot.}

\item{lim}{Limits (in the dimensions of x) used for plotting, if add==FALSE. Defaults to cutoff, but can be manually set as a numeric vector of length 2, giving the lower and upper limits of the plot.}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{fill}{Fill color for the plotted violin}

\item{col}{Line color for the plotted violin}

\item{lwd}{Line width for the plotted violin}

\item{lty}{Line width for the plotted violin}

\item{...}{Other arguments to be passed on to function in parameter stat}
}
\value{
A violin plot and a data.frame containing the original and modified plotting statistic and independent variable against which it is plotted.
}
\description{
Generate a violin plot
}
\details{
Viol provides a versatile function for generating violin plots and adding them to r base graphics. The default plotting statistic is density(), resulting in the standard violin plot. However, density can be overridden by entering any function that can take x or x2 as its first argument, or any numeric vector containing the data to be plotted, as long as this vector is the same length as x.
}
\examples{
viol(x=c(1,2,2,2,3,4,4,3,2,2,3,3,4,5,3,3,2,2,1,6,7,6,9),pos=1, add=FALSE)
viol(c(1:10), width=9, stat=rmean, pos=0, add=FALSE)
viol(c(1:10), stat=c(11:20), pos=0, add=FALSE)
}
