% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_expand_time.R
\name{tax_expand_time}
\alias{tax_expand_time}
\title{Generate pseudo-occurrences from temporal range data}
\usage{
tax_expand_time(
  taxdf,
  max_ma = "max_ma",
  min_ma = "min_ma",
  bins = NULL,
  scale = "GTS2020",
  rank = "stage",
  ext_orig = TRUE
)
}
\arguments{
\item{taxdf}{\code{dataframe}. A dataframe of taxa (such as that
produced by \code{\link{tax_range_time}}) with columns for the maximum and
minimum ages (FADs and LADs). Each row should represent a unique taxon.
Additional columns may be included (e.g. taxon names, additional taxonomy,
etc) and will be included in the returned \code{data.frame}. If required,
\code{numeric} ages can be generated from interval names via the
\code{\link{look_up}} function.}

\item{max_ma}{\code{character}. The name of the column you wish to be treated
as the maximum limit (FADs) of the age range (e.g. "max_ma").}

\item{min_ma}{\code{character}. The name of the column you wish to be treated
as the minimum limit (LADs) of the age range (e.g. "min_ma").}

\item{bins}{\code{dataframe}. A dataframe of the bins that you wish to
allocate pseudo-occurrences to such as that returned by
\code{\link[palaeoverse:time_bins]{time_bins()}}. This dataframe must
contain at least the following named columns: "bin", "max_ma" and
"min_ma". Columns "max_ma" and "min_ma" must be \code{numeric} values.}

\item{scale}{\code{character}. Specify the desired geological timescale to be
used, either "GTS2020" or "GTS2012". Passed to
\code{\link[palaeoverse:time_bins]{time_bins()}} if \code{bins} is not
specified.}

\item{rank}{\code{character}. Specify the desired stratigraphic rank. Choose
from: "stage", "epoch", "period", "era", and "eon". Passed to
\code{\link[palaeoverse:time_bins]{time_bins()}} if \code{bins} is not
specified.}

\item{ext_orig}{\code{logical}. Should two additional columns be added to
identify the intervals in which taxa originated and went extinct?}
}
\value{
A \code{dataframe} where each row represents an interval during which
a taxon in the original user-supplied data persisted. The columns are
identical to those in the user-supplied data with additional columns
included to identify the intervals. If \code{ext_orig} is \code{TRUE},
two additional columns are added to identify in which intervals taxa
originated and went extinct.
}
\description{
A function to generate interval-level pseudo-occurrences for taxa based on
temporal ranges (e.g. the output of \code{\link{tax_range_time}}). While the
resulting pseudo-occurrences should not be treated as equivalent to actual
occurrence data (e.g. like that from the Paleobiology Database), such
pseudo-occurrences may be useful for performing statistical analyses where
the row representing a taxon must be replicated for each interval through
which the taxon persisted.
}
\section{Developer(s)}{

William Gearty & Lewis A. Jones
}

\section{Reviewer(s)}{

Lewis A. Jones
}

\examples{
taxdf <- data.frame(name = c("A", "B", "C"),
                    max_ma = c(150, 60, 30),
                    min_ma = c(110, 20, 0))
ex <- tax_expand_time(taxdf)

bins <- time_bins(scale = "GTS2012", rank = "stage")
ex2 <- tax_expand_time(taxdf, bins = bins)
}
