% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.RNE.r, R/rne.R
\name{plot.RNE}
\alias{plot.RNE}
\alias{rne}
\title{Random, neighbour, environment deletion analysis for transfer function
models}
\usage{
\method{plot}{RNE}(x, which = 1, ylim, ...)

rne(
  y,
  env,
  geodist,
  fun,
  neighbours,
  subsets = c(1, 0.75, 0.5, 0.25, 0.1),
  nrep = 10,
  ...
)
}
\arguments{
\item{x}{RNE object to be plotted}

\item{which}{Which column of the results to plot eg if more than one WAPLS
component is calculated}

\item{ylim}{Y-limits of the plot}

\item{...}{Arguments passed to fun}

\item{y}{Community data, or distance object, or distance matrix}

\item{env}{Environmental variable}

\item{geodist}{Matrix of geographical distances between sites}

\item{fun}{Transfer function}

\item{neighbours}{Neighbourhood radii}

\item{subsets}{Proportion of sites to retain in random deletion}

\item{nrep}{integer, number of times to delete sites at random}
}
\value{
Returns an RNE object, list with two components
\itemize{
\item{random }{Performance with random deletion.}
\item{neighbour }{Performance with deletion by neighbourhood,
or environment}
}
}
\description{
Calculates effect of deleting sites from training set at random,
from a geographic neighbourhood, or from an environmental neighbourhood.
A simple graphical technique for gauging the effect of spatial
autocorrelation on the transfer function model.
}
\details{
Finds the leave-one-out transfer function performance if sites are
deleted at random (repeated 10 times to reduce variance in results), from a
neighbourhood zone, or by deleting environmentally close sites.
}
\section{Functions}{
\itemize{
\item \code{plot(RNE)}: Plot RNE object

}}
\examples{
require(fields)
require(rioja)
data(arctic.env)
data(arctic.pollen)

# using just the first 20 sites so that code runs in an reasonable time
arctic.dist <- rdist.earth(
  x1 = arctic.env[1:20, c("Longitude", "Latitude")],
  miles = FALSE
)
arctic.rne <- rne(
  y = arctic.pollen[1:20, ], env = arctic.env$tjul[1:20],
  geodist = arctic.dist, fun = MAT, neighbours = c(0, 200),
  subsets = c(1, .5), nrep = 2, k = 5
)

plot(arctic.rne)
}
\references{
Telford, R. J. and Birks, H. J. B. (2009) Evaluation of transfer
functions in spatially structured environments.
\emph{Quaternary Science Reviews} \bold{28}: 1309--1316.
\doi{10.1016/j.quascirev.2008.12.020}
}
\author{
Richard Telford \email{Richard.Telford@bio.uib.no}
}
\keyword{multivariate}
