% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_args.R
\name{standard_args}
\alias{standard_args}
\title{Standard Template Arguments}
\arguments{
\item{at}{\code{Date} from which to take the version. Default: \code{NULL}}

\item{attr}{\code{logical} if a package and its version should be added as an attribute of data.frame or for FALSE as an additional record. Default: TRUE}

\item{base}{\code{logical} if to add base packages too. If \code{TRUE} then \code{pacs::pacs_base()} are taken into account. Default: \code{FALSE}}

\item{built}{\code{logical} if to add an R version under which each package was installed.
Useful mainly for a local usage.
Packages installed with a previous version of R could not work correctly with the new version of R. Default: \code{FALSE}}

\item{checkred}{\code{list} with two named fields, \code{scope} and \code{flavor}. \code{scope} of R CRAN check pages statuses to consider, any of \code{c("ERROR", "FAIL", "WARN", "NOTE")}.
\code{flavor} is a vector of CRAN machines to consider, which might be retrieved with \code{pacs::cran_flavors()$Flavor}.
By default an empty scope field deactivated assessment for \code{checkred} column, and NULL flavor will results in checking all machines.
Default: \code{list(scope = character(0), flavor = NULL)}}

\item{description_v}{\code{logical} if the dependencies version should be taken from description files, minimal required. By default installed versions are taken. Default: \code{FALSE}}

\item{exclude_joint}{\code{integer} exclude packages which are dependencies of at least N other packages, not count main package dependencies. Default: \code{0}}

\item{fields}{\code{character} vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{flavors}{\code{character} vector of CRAN server names to consider, possible names could be get with \code{pacs::cran_flavors()$Flavor}.
The \code{pacs::match_flavors()} function could be used to get CRAN server names matched for your local \code{OS}.
By default all CRAN machines are considered \code{NULL} value. Default: \code{NULL}}

\item{from}{\code{Date} the lower limit. Default: \code{NULL}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{lifeduration}{\code{logical} if to assess life duration for each package in the library.
For installed newest releases of packages, a local evaluation is used.
\verb{MEATCRAN CRANDB} is used for libraries with less than 500 packages.
Otherwise the direct web page download from CRAN is used.
Default: `FALSE``}

\item{limit}{\code{numeric} at least days to treat as healthy, ">=limit". Default: 14}

\item{local}{\code{logical} if to use local repository (or newest remote packages). Default: \code{FALSE}}

\item{na.rm}{\code{logical} if to remove \code{NA} values.}

\item{new}{\code{character} a new version of package, default newest version. Default: \code{NULL}}

\item{old}{\code{character} an old version of package, default local version. Default: \code{NULL}}

\item{pac}{\code{character} a package name.}

\item{pacs}{\code{character} vector of packages names.}

\item{path}{\code{character} path to the shiny app. Default: \code{"."}}

\item{repos}{\code{character} vector of repositories URLs to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}

\item{recursive}{\code{logical} if to assess the dependencies recursively. Default: TRUE}

\item{scope}{\code{character} vector scope of the check, accepted values c("ERROR", "FAIL", "WARN", "NOTE"). Default: \code{c("ERROR", "FAIL")}}

\item{source}{\code{character} one of \code{c("cran", "crandb")}.
Using the \verb{MEATCRAN CRANDB} or the direct web page download from CRAN.
When \code{"crandb"} is set then \code{options(pacs.crandb_ntry = 3)} and \code{options(pacs.crandb_nsleep = 0.001)} can be used to control the fetch.
\code{"pacs.crandb_ntry"} can be used to set the maximum number of try outs, by default 3.
\code{"pacs.crandb_nsleep"} can be used to set the sleep duration between fetch try outs, by default 0.001.
Default: \code{"cran"}}

\item{startup}{\code{logical} include only \code{startup} packages. Default: \code{FALSE}}

\item{to}{\code{Date} the upper limit. Default: \code{NULL}}

\item{vec}{\code{character} vector.}

\item{version}{\code{character} version of a package. Default: \code{NULL}}

\item{versions}{\code{character} vector of packages versions.}
}
\description{
Standard Template Arguments
}
\keyword{internal}
