% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comapre.R
\name{pac_compare_versions}
\alias{pac_compare_versions}
\title{Compare DESCRIPTION files dependencies between specific CRAN packages versions}
\usage{
pac_compare_versions(
  pac,
  old = NULL,
  new = NULL,
  fields = c("Imports", "Depends", "LinkingTo"),
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{old}{\code{character} an old version of package, default local version. Default: \code{NULL}}

\item{new}{\code{character} a new version of package, default newest version. Default: \code{NULL}}

\item{fields}{\code{character} vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{\code{character} vector repositories URLs to use. Used only for the validation. Default \verb{https://cran.rstudio.com/}}
}
\value{
\code{data.frame} with 4 columns.
\describe{
\item{Package}{character package names.}
\item{Version.OLD}{character versions of dependencies required by an old package version.}
\item{Version.NEW}{character versions of dependencies required by a new package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that both versions have the same requirement. -1 means that the new version remove this requirement. 1 means that the new version added a new requirement.}
}
}
\description{
using the remote github CRAN mirror to compare DESCRIPTION files dependencies between specific packages versions.
}
\examples{
\dontrun{
pacs::pac_compare_versions("memoise", "0.2.1", "2.0.0")
pacs::pac_compare_versions("memoise", "0.2.1")
# local version to newest one
pacs::pac_compare_versions("memoise")
}
}
