% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/circlePlotData.R
\name{circlePlotData}
\alias{circlePlotData}
\title{Generate plotting data for circles.}
\usage{
circlePlotData(layout, npoints = 25, xyr.cols = 1:3, id.col = NULL)
}
\arguments{
\item{layout}{A matrix or data.frame of circle data (x, y, radius). May contain
  other columns, including an optional ID column.}

\item{npoints}{The number of vertices to generate for each circle.}

\item{xyr.cols}{Indices or names of columns for x, y, radius (in that order).
  Default is columns 1-3.}

\item{id.col}{Optional index or name of column for circle IDs in output.
  If not provided, the output circle IDs will be the row numbers of
  the input circle data.}
}
\value{
A data.frame with columns: id, x, y; where id is the unique
  integer identifier for each circle.
}
\description{
Given a matrix or data.frame of circle layout data (circle centres, radii
and optional IDs), generates a data.frame of plotting data to use with ggplot.
}
\examples{
\dontrun{
## draw some random circles with ggplot
library(ggplot2)

xmax <- 100
ymax <- 100
rmin <- 10
rmax <- 20
N <- 20

## Random centre coordinates and radii
layout <- data.frame(id = 1:N,
                     x = runif(N, 0, xmax),
                     y = runif(N, 0, ymax),
                     r = runif(N, rmin, rmax))

## Get data for circle vertices
plotdat <- circlePlotData(layout, id.col=1, xyr.cols=2:4)

## Draw circles annotated with their IDs
ggplot() +
  geom_polygon(data=plotdat, aes(x, y, group=id), fill=NA, colour="black") +
  geom_text(data=layout, aes(x, y, label=id)) +
  coord_equal() +
  theme_bw()
}
}
\seealso{
\code{\link{circleVertices}}
}

