% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_parameter_estimation_survival.R
\name{plot_survival_cox_covariates}
\alias{plot_survival_cox_covariates}
\title{Plotting survival function for all covariates  calculated from
cox regression results and returned coefficients}
\usage{
plot_survival_cox_covariates(
  coxfit,
  dataset,
  param_to_be_estimated,
  covariates,
  indep_var
)
}
\arguments{
\item{coxfit}{cox regression fit result}

\item{dataset}{param describing the methods}

\item{param_to_be_estimated}{parameter to be estimated}

\item{covariates}{covariates}

\item{indep_var}{independent variable}
}
\value{
plot and the survival function values
}
\description{
Plotting survival function for all covariates  calculated from
cox regression results and returned coefficients
}
\examples{
\donttest{
 data_for_survival <- survival::lung
 surv_estimated <- use_coxph_survival("status", data_for_survival, "sex",
 covariates = c("ph.ecog"), "time")
 plot_survival_cox_covariates(surv_estimated$fit,data_for_survival,
 "status", covariates = c("ph.ecog"), "sex")
 }
}
