% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3c_costing_resource_use_functions.R
\name{costing_AandE_admission}
\alias{costing_AandE_admission}
\title{Function to estimate the cost of inpatient admission but taken from
GP records where  code or description known}
\usage{
costing_AandE_admission(
  ind_part_data,
  code_ae,
  descrip_ae,
  number_use_ae,
  type_admit_ae,
  unit_cost_data,
  code_col,
  type_admit_col,
  description_col,
  unit_cost_col,
  cost_calculated_in = "attendance",
  sheet = NULL
)
}
\arguments{
\item{ind_part_data}{IPD}

\item{code_ae}{column name of  code (for inpatient admission)}

\item{descrip_ae}{column name of description for inpatient admission}

\item{number_use_ae}{the number of days spent in each admission if that
is a criteria to be included. Otherwise each admission will be costed}

\item{type_admit_ae}{term indicating admission and type of attendance}

\item{unit_cost_data}{unit cost data file with  code/descriptions
and unit costs are listed for inpatient admission}

\item{code_col}{code column name in unit cost data}

\item{type_admit_col}{colname that describes type of the attendance and}

\item{description_col}{column name of description of inpatient admission in
the unit cost data}

\item{unit_cost_col}{column name of unit cost in unit_cost_data}

\item{cost_calculated_in}{name of unit where the cost is calculated
assumed to be per admission}

\item{sheet}{sheet where the unit costs are listed in the unit costs data
file}
}
\value{
the calculated cost of inpatient admission long with original data
}
\description{
Function to estimate the cost of inpatient admission but taken from
GP records where  code or description known
}
\examples{
costs_file <- system.file("extdata",
"National_schedule_of_NHS_costs_2019_AandE.csv", package = "packDAMipd")
datafile <- system.file("extdata", "resource_use_ae_ip.csv",
package = "packDAMipd")
ind_part_data <- packDAMipd::load_trial_data(datafile)
unit_cost_data <- packDAMipd::load_trial_data(costs_file)
result <- costing_AandE_admission(ind_part_data = ind_part_data,
code_ae = "code", descrip_ae = NULL, number_use_ae = "number_use",
type_admit_ae = "type_admit", unit_cost_data = unit_cost_data,
code_col = "Currency_Code", type_admit_col = "Service_Code",
description_col = NULL, unit_cost_col ="National_Average_Unit_Cost",
cost_calculated_in = "attendance")
}
