% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3c_costing_resource_use_functions.R
\name{costing_inpatient_daycase_admission}
\alias{costing_inpatient_daycase_admission}
\title{Function to estimate the cost of inpatient admission but taken from
GP records where HRG code or description known}
\usage{
costing_inpatient_daycase_admission(
  ind_part_data,
  hrg_code_ip_admi,
  descrip_ip_admi,
  number_use_ip_admi,
  elective_col,
  unit_cost_data,
  hrg_code_col,
  description_col,
  unit_cost_col,
  cost_calculated_in = "admission"
)
}
\arguments{
\item{ind_part_data}{IPD}

\item{hrg_code_ip_admi}{column name of hrg code (for inpatient admission)}

\item{descrip_ip_admi}{column name of description for inpatient admission}

\item{number_use_ip_admi}{the number of days spent in each admission if that
is a criteria to be included. Otherwise each admission will be costed}

\item{elective_col}{colname to say whether it is an elective admission or
non elective admission}

\item{unit_cost_data}{unit cost data file with hrg code/descriptions
and unit costs are listed for inpatient admission}

\item{hrg_code_col}{hrg code column name in unit cost data}

\item{description_col}{column name of description of inpatient admission in
the unit cost data}

\item{unit_cost_col}{column name of unit cost in unit_cost_data}

\item{cost_calculated_in}{name of unit where the cost is calculated
assumed to be per admission}
}
\value{
the calculated cost of inpatient admission long with original data
}
\description{
Function to estimate the cost of inpatient admission but taken from
GP records where HRG code or description known
}
\examples{
costs_file <- system.file("extdata",
 "National_schedule_of_NHS_costs_2019.csv",
 package = "packDAMipd")
 datafile <- system.file("extdata", "resource_use_hc_ip.csv",
 package = "packDAMipd")
 ind_part_data <- packDAMipd::load_trial_data(datafile)
 unit_cost_data <- packDAMipd::load_trial_data(costs_file)
 result <- costing_inpatient_daycase_admission(ind_part_data,
 hrg_code_ip_admi = "HRGcode", descrip_ip_admi = NULL,
number_use_ip_admi = "number_use", elective_col = "EL",
unit_cost_data, hrg_code_col = "Currency_Code", description_col = NULL,
 unit_cost_col ="National_Average_Unit_Cost",
 cost_calculated_in = "admission")
}
