#' Precipitation box plot
#'
#' Function for plotting (boxplot) time-series of area averaged precipitation.
#'
#' @import data.table ggplot2
#' @importFrom methods as
#' @param x a data.table generated by \code{\link{make_ts}}
#' @return ggplot object
#' @export

plot_box <- function(x){
  x <- as.data.table(x)
  p00 <- ggplot(x, aes(x = as.factor(month(date)), y = value)) +
    geom_boxplot(fill = "#377eb8") +
    theme_bw() +
    labs(x = NULL, y = "Precipitation [mm]", title = NULL) +
    scale_x_discrete(breaks = seq(1, 12), 
                     labels = c("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
                                "Aug", "Sep", "Oct", "Nov", "Dec")) +
    theme(panel.grid.major.x = element_blank(),
          plot.title = element_text(size=24),
          axis.text = element_text(size = 20),
          axis.title = element_text(size = 24))
  return(p00)
}