% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pARIgene.R
\name{pARIgene}
\alias{pARIgene}
\title{Permutation-based All-Resolutions Inference for Gene Expression Data}
\usage{
pARIgene(X= NULL, pathways, alpha = 0.05, family = "simes", delta = 0, 
B = 1000, test.type = "one_sample", complete = FALSE, iterative = FALSE, 
approx = TRUE, ncomb = 100, step.down = FALSE, max.step = 10, ...)
}
\arguments{
\item{X}{Data matrix where rows represent the \eqn{m} variables and columns the \eqn{n} observations.}

\item{pathways}{List of pathways where names indicates the name of the pathway.}

\item{alpha}{Numeric value in `[0,1]`. \eqn{\alpha} level to control the family-wise error rate. Default to 0.05.}

\item{family}{String character. Name of the family confidence envelope to compute the critical vector 
from \code{"simes"}, \code{"aorc"}, \code{"beta"}, \code{"higher.criticism"}, and \code{"power"}.
Default to "simes".}

\item{delta}{Numeric value. \eqn{\delta} value. Please see the reference below. Default to 0.}

\item{B}{Numeric value. Number of permutations, default to 1000.}

\item{test.type}{Character string. Choose a type of tests among \code{"one_sample"}, i.e., one-sample t-tests, or \code{"two_samples"}, i.e., two-samples t-tests. Default \code{"one_sample"}.}

\item{complete}{Boolean value. If \code{TRUE} the sets of critical vectors and the raw \eqn{p}-values are returned. Default to \code{FALSE}.}

\item{iterative}{Boolean value. If \code{iterative = TRUE}, the iterative method is applied (computationally demanding). Default to \code{FALSE}. Please see the reference below.}

\item{approx}{Boolean value. Default to \code{TRUE}. If you are analyzing high dimensional data, we suggest to put \code{approx = TRUE} to speed up the computation time. Please see the reference below.}

\item{ncomb}{Numeric value. If \code{approx = TRUE}, you must decide how many random sub collections (level of approximation) considered. Default to 100.}

\item{step.down}{Boolean value. Default to \code{FALSE} If you want to compute the lambda calibration parameter using the step-down approach put \code{TRUE}. Please see the reference below.}

\item{max.step}{Numeric value. Default to 10. Maximum number of steps for the step down approach, so useful when \code{step.down = TRUE}.}

\item{...}{Further arguments}
}
\value{
by default returns a list with the following objects: 
\describe{
 \item{discoveries}{lower bound for the number of true discoveries in the set selected}
 \item{ix}{selected variables} 
}
If \code{complete = TRUE} the raw \code{pvalues} and \code{cv} critical vector are also returned.
}
\description{
This function computes the lower bound for the  number of true 
discoveries within each cluster (pathways) of Gene Expression Data.
}
\references{
For the general framework of All-Resolutions Inference see:

Goeman, Jelle J., and Aldo Solari. "Multiple testing for exploratory research.
" Statistical Science 26.4 (2011): 584-597.

For permutation-based All-Resolutions Inference see:

Andreella, A., Hemerik, J., Finos, L., Weeda, W., & Goeman, J. (2023). Permutation-based true discovery proportions for functional magnetic resonance imaging cluster analysis. Statistics in Medicine, 42(14), 2311-2340.
}
\seealso{
The type of tests implemented: \code{\link{signTest}} \code{\link{permTest}}.
}
\author{
Angela Andreella
}
