% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args.R
\name{filestosend_get}
\alias{filestosend_get}
\title{Determine which arguments are filepaths}
\usage{
filestosend_get(arglist, wd = NULL)
}
\arguments{
\item{arglist}{Character vector of arguments}

\item{wd}{Working directory in which to look for files}
}
\value{
Character vector
}
\description{
Return filepaths from arguments. These filepaths can then be
used to identify files/folders for sending to the Docker container.
}
\examples{
library(outsider.base)
# set-up: create wd and files to send
wd <- file.path(tempdir(), 'results')
dir.create(wd)
file1 <- file.path(wd, 'file1')
file.create(file1)
file2 <- file.path(wd, 'file2')
file.create(file2)


# identify files to be sent to container
arglist <- c('-in', file1, '-out', file2)
(filestosend_get(arglist = arglist))
# works with -wd
arglist <- c('-in', 'file1', '-out', 'file2', '-wd', wd)
(filestosend_get(arglist = arglist, wd = wd))


# clean-up
unlink(wd, recursive = TRUE)
}
