% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth_from_secret}
\alias{auth_from_secret}
\title{Use secrets to authorize R package to access Google Slides API}
\usage{
auth_from_secret(access_token = NULL, refresh_token = NULL)
}
\arguments{
\item{access_token}{Access token can be obtained from running authorize() interactively: token <-authorize(); token$credentials$access_token}

\item{refresh_token}{Refresh token can be obtained from running authorize() interactively: token <-authorize(); token$credentials$refresh_token}
}
\value{
OAuth token saved to the environment so the package can use the users' Google data
}
\description{
This is a function to authorize the R package to access the Google Slides API. If no
client.id and client.secret is provided, the package would provide predefined values.
}
\examples{
\dontrun{

token <- authorize()

auth_from_secret(
  token$credentials$access_token,
  token$credentials$refresh_token
)
}

}
