% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDetectorScore_normalizeScore.R
\name{NormalizeScore}
\alias{NormalizeScore}
\title{Normalize Score using Max and Min normalization}
\usage{
NormalizeScore(real.score, perfect.score, null.score)
}
\arguments{
\item{real.score}{Detector score. See \code{\link{GetDetectorScore}}.}

\item{perfect.score}{Perfect detector score; one that outputs all true positives and no false
positives. See \code{\link{GetNullAndPerfectScores}}.}

\item{null.score}{Perfect detector score; one that outputs all true positives and no false
positives. See \code{\link{GetNullAndPerfectScores}}.}
}
\value{
Normalized score.
}
\description{
\code{ReduceAnomalies} It reduces the number of detected anomalies. This function is
designed to reduce the number of false positives keeping only the first detection of all those
that are close to each other. This proximity distance is defined by a window
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

# Add is.real.anomaly column
df$is.real.anomaly <- 0
df[c(25,80,150), "is.real.anomaly"] <- 1

## Calculate anomalies
result <- CpSdEwma(
  data = df$value,
  n.train = 5,
  threshold = 0.01,
  l = 3
)
res <- cbind(df, result)

# Get null and perfect scores
np.scores <- GetNullAndPerfectScores(df)
np.standard <- np.scores[1,]
np.fp <- np.scores[2,]
np.fn <- np.scores[3,]

# Get detector score
scores <- GetDetectorScore(res, print = FALSE, title = "")

# Normalize standard score
NormalizeScore(scores$standard, np.standard$perfect.score, np.standard$null.score)

# Normalize low_FP_rate score
NormalizeScore(scores$low_FP_rate, np.fp$perfect.score, np.fp$null.score)

# Normalize low_FN_rate score
NormalizeScore(scores$low_FN_rate, np.fn$perfect.score, np.fn$null.score)
}
\references{
A. Lavin and S. Ahmad, “Evaluating Real-time Anomaly Detection Algorithms – the
Numenta Anomaly Benchmark,” in 14th International Conference on Machine Learning and
Applications (IEEE ICMLA’15), 2015.
}
