% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_manhattan.R
\name{plot_manhattan}
\alias{plot_manhattan}
\title{Plot results from \code{manhattan()}}
\usage{
plot_manhattan(data)
}
\arguments{
\item{data}{Data frame containing the necessary columns from \code{manhattan()} output for plotting:
- \code{variant_position}: Variant position
- \code{variant_chromosome}: Variant chromosome
- \code{pval}: P-value
- \code{variant_id}: Variant ID
- \code{best_locus2genes_score}: Best locus2genes score
- \code{best_locus2genes_gene_symbol}: Best locus2genes gene symbol}
}
\value{
A Manhattan plot visualizing the GWAS results.
}
\description{
This function generates a Manhattan plot using the statistical summary data
obtained from the \code{manhattan()} function. Top 3 genes (based on p-value) are annotated per chromosome.
}
\examples{
\dontrun{
p <- manhattan(study_id = "GCST003044") \%>\% plot_manhattan()

p
}
}
