% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{osqpSettings}
\alias{osqpSettings}
\title{Settings for OSQP}
\usage{
osqpSettings(rho = 0.1, sigma = 1e-06, max_iter = 4000L,
  eps_abs = 0.001, eps_rel = 0.001, eps_prim_inf = 1e-04,
  eps_dual_inf = 1e-04, alpha = 1.6, linsys_solver = c(QDLDL_SOLVER =
  0L), delta = 1e-06, polish = FALSE, polish_refine_iter = 3L,
  verbose = TRUE, scaled_termination = FALSE,
  check_termination = 25L, warm_start = TRUE, scaling = 10L,
  adaptive_rho = 1L, adaptive_rho_interval = 0L,
  adaptive_rho_tolerance = 5, adaptive_rho_fraction = 0.4)
}
\arguments{
\item{rho}{ADMM step rho}

\item{sigma}{ADMM step sigma}

\item{max_iter}{maximum iterations}

\item{eps_abs}{absolute convergence tolerance}

\item{eps_rel}{relative convergence tolerance}

\item{eps_prim_inf}{primal infeasibility tolerance}

\item{eps_dual_inf}{dual infeasibility tolerance}

\item{alpha}{relaxation parameter}

\item{linsys_solver}{which linear systems solver to use, 0=QDLDL, 1=MKL Pardiso}

\item{delta}{regularization parameter for polish}

\item{polish}{boolean, polish ADMM solution}

\item{polish_refine_iter}{iterative refinement steps in polish}

\item{verbose}{boolean, write out progress}

\item{scaled_termination}{boolean, use scaled termination criteria}

\item{check_termination}{integer, check termination interval. If 0, termination checking is disabled}

\item{warm_start}{boolean, warm start}

\item{scaling}{heuristic data scaling iterations. If 0, scaling disabled}

\item{adaptive_rho}{cboolean, is rho step size adaptive?}

\item{adaptive_rho_interval}{Number of iterations between rho adaptations rho. If 0, it is automatic}

\item{adaptive_rho_tolerance}{Tolerance X for adapting rho. The new rho has to be X times larger or 1/X times smaller than the current one to trigger a new factorization}

\item{adaptive_rho_fraction}{Interval for adapting rho (fraction of the setup time)}
}
\description{
For further details please consult the OSQP documentation:
\url{https://osqp.org/}
}
