/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.ltl.LTLForcingRomsPisces;
import java.io.IOException;
import ucar.nc2.NetcdfFile;

public class LTLForcingLaure
extends LTLForcingRomsPisces {
    private double[][][][] data;

    public LTLForcingLaure(int rank) {
        super(rank);
    }

    @Override
    public void initLTLGrid() {
        super.initLTLGrid();
        this.loadData();
    }

    private void loadData() {
        this.info("Loading all plankton data...");
        this.data = new double[this.getConfiguration().getNStepYear()][this.getConfiguration().getNPlankton()][][];
        for (int t = 0; t < this.getConfiguration().getNStepYear(); ++t) {
            for (int p = 0; p < this.getConfiguration().getNPlankton(); ++p) {
                this.data[t][p] = this.getIntegratedBiomass(p, t);
            }
        }
        this.info("All plankton data loaded");
    }

    private double[][] getIntegratedBiomass(int p, int iStepSimu) {
        float[][][] dataInit = null;
        String ncfile = this.planktonFileListNetcdf[this.getIndexStepLTL(iStepSimu)];
        try {
            NetcdfFile nc = NetcdfFile.open(ncfile);
            dataInit = (float[][][])nc.findVariable(this.plktonNetcdfNames[p]).read().copyToNDJavaArray();
        }
        catch (IOException ex) {
            this.error("Error loading LTL variable " + this.plktonNetcdfNames[p] + " from file " + ncfile, ex);
        }
        return this.verticalIntegration(dataInit, this.depthOfLayer, this.getConfiguration().getFloat("ltl.integration.depth"));
    }

    @Override
    double[][] getRawBiomass(int iPlankton, int iStepSimu) {
        return this.data[this.getIndexStepLTL(iStepSimu)][iPlankton];
    }
}

