% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads_api.R
\name{download_os_opendata}
\alias{download_os_opendata}
\alias{download_os_opendata.product_list}
\alias{download_os_opendata.character}
\title{Download OS OpenData Products}
\usage{
download_os_opendata(product, ...)

\method{download_os_opendata}{product_list}(
  product,
  file_name,
  file_format,
  area,
  output_dir,
  overwrite = FALSE,
  ...
)

\method{download_os_opendata}{character}(
  product,
  file_name,
  file_format,
  file_subformat,
  area,
  output_dir,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{product}{A \code{product_list} object retrieved and filtered using
\code{list_os_opendata}. Alternatively, a data product name as a character
string.}

\item{...}{Additional parameters. Not currently used.}

\item{file_name}{(character) Filter downloads to only include those with this
file name. Optional.}

\item{file_format}{(character) Filter downloads to only include those with
this format. Optional.}

\item{area}{(character) Filter downloads for only this area. Use 'GB' for all
Great Britain. Optional.}

\item{output_dir}{Path to the directory where the downloaded files will be
saved.}

\item{overwrite}{Boolean. Should existing files be overwritten? Default is
\code{FALSE}.}

\item{file_subformat}{(character) Filter downloads to only include those with
this subformat. Optional and only used when \code{product} is a character
string.}
}
\value{
Silently returns the directory where the downloaded files are
stored.
}
\description{
Main function for downloading OS open data product files to your local
machine.
}
\details{
The OS Downloads API assists with the discovery and download of OS
OpenData and OS Premium data packages. This function is used as the main
step to download open data products to your local machine. It is designed
to work best after \code{list_os_opendata} is first used to search and
filter for the specific download product. The \code{product_list} returned
by the listing step can be used as the input value to download the desired
files. Alternatively, it is possible to supply a product name and filtering
options based on file formats and areas.

The optional \code{area} filter is based on two-letter British National
Grid tiles. Use 'GB' for all of Great Britain. Valid values area: GB, HP,
HT, HU, HW, HX, HY, HZ, NA, NB, NC, ND, NF, NG, NH, NJ, NK, NL, NM, NN, NO,
NR, NS, NT, NU, NW, NX, NY, NZ, OV, SD, SE, TA, SH, SJ, SK, TF, TG, SM, SN,
SO, SP, TL, TM, SR, SS, ST, SU, TQ, TR, SV, SW, SX, SY, SZ, TV.

For more information on the Downloads API, see
\url{https://osdatahub.os.uk/docs/downloads/technicalSpecification}.
}
\examples{
\donttest{
# Search and filter available open products.
prod_list <- list_os_opendata('OpenGreenSpace',
                              file_format = 'GeoPackage',
                              area = 'GB')

# Use the product list to initiate a download.
download_os_opendata(prod_list, output_dir = tempdir())

# Combine search and download.
# Be sure to know the products to avoid downloading more data than desired.
download_os_opendata(product = 'OpenGreenSpace',
                     file_format = 'GeoPackage',
                     area = 'GB',
                     output_dir = tempdir())
}

}
\seealso{
\code{\link[=list_os_opendata]{list_os_opendata()}}
}
