% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\docType{methods}
\name{slice-methods}
\alias{slice-methods}
\alias{slice}
\alias{slice.nifti}
\alias{slice,ANY-method}
\alias{slice,afni-method}
\alias{slice,anlz-method}
\alias{slice,nifti-method}
\title{Methods for Function `slice'}
\usage{
slice(x, ...)

\S4method{slice}{nifti}(x, z = 1, w = 1, col = gray(0:64/64),
  plane = c("axial", "coronal", "sagittal"), zlim = NULL, xlab = "",
  ylab = "", axes = FALSE, oma = rep(0, 4), mar = rep(0, 4),
  bg = "black", useRaster = TRUE, ...)

\S4method{slice}{anlz}(x, z = 1, w = 1, col = gray(0:64/64),
  plane = c("axial", "coronal", "sagittal"), zlim = NULL, xlab = "",
  ylab = "", axes = FALSE, oma = rep(0, 4), mar = rep(0, 4),
  bg = "black", useRaster = TRUE, ...)

\S4method{slice}{afni}(x, ...)
}
\arguments{
\item{x}{is an object of class \code{nifti} or similar.}

\item{\dots}{other arguments to the \code{image} function may be provided
here.}

\item{z}{is the slice to be displayed (ignored when \code{plot.type =
"multiple"}).}

\item{w}{is the time point to be displayed (4D arrays only).}

\item{col}{is grayscale (by default).}

\item{plane}{is the plane of acquisition to be displayed (choices are
\sQuote{axial}, \sQuote{coronal}, \sQuote{sagittal}).}

\item{zlim}{is set to \code{NULL} by default and utilizes the internal image
range.}

\item{xlab}{is set to \dQuote{} since all margins are set to zero.}

\item{ylab}{is set to \dQuote{} since all margins are set to zero.}

\item{axes}{is set to \code{FALSE} since all margins are set to zero.}

\item{oma}{is the size of the outer margins in the \code{par} function.}

\item{mar}{is the number of lines of margin in the \code{par} function.}

\item{bg}{is the background color in the \code{par} function.}

\item{useRaster}{if \code{TRUE}, a bitmap raster is used to plot 
the image instead of polygons. Passed to \code{\link[graphics]{image}}}
}
\description{
Produce \dQuote{lightbox} layout of slices for \code{nifti}, \code{anlz} and
\code{afni} objects.
}
\details{
Uses the S3 generic function \code{slice}, with medical-image friendly
settings, to display \code{nifti}, \code{anlz} and \code{afni} class objects
in a \dQuote{lightbox} layout.
}
\section{Methods}{
 \describe{ \item{x = "ANY"}{Generic function: see
\code{\link[graphics]{image}}.} \item{x = "nifti"}{Produce images for
\code{x}.} \item{x = "anlz"}{Produce images for \code{x}.} \item{x =
"afni"}{Produce images for \code{x}.} }
}

\seealso{
\code{\link{orthographic-methods}}, \code{\link{image-methods}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\keyword{methods}
