% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cal_max.R
\docType{methods}
\name{cal_max-methods}
\alias{cal.max}
\alias{cal.max,anlz-method}
\alias{cal.max,nifti-method}
\alias{cal.max<-}
\alias{cal.max<-,anlz-method}
\alias{cal.max<-,nifti-method}
\alias{cal_max}
\alias{cal_max,anlz-method}
\alias{cal_max,nifti-method}
\alias{cal_max-methods}
\alias{cal_max-methods,}
\alias{cal_max<-}
\alias{cal_max<-,anlz-method}
\alias{cal_max<-,nifti-method}
\title{Extract Image Attribute \code{cal_max}}
\usage{
cal_max(object)

\S4method{cal_max}{nifti}(object)

\S4method{cal_max}{anlz}(object)

cal_max(object) <- value

\S4method{cal_max}{nifti}(object) <- value

\S4method{cal_max}{anlz}(object) <- value

cal.max(object)

\S4method{cal.max}{nifti}(object)

\S4method{cal.max}{anlz}(object)

cal.max(object) <- value

\S4method{cal.max}{nifti}(object) <- value

\S4method{cal.max}{anlz}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{cal_max} field.}
}
\description{
Methods that act on the \code{cal_max} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/avg152T1_LR_nifti.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
download.file(url, urlfile, quiet=TRUE)
}
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
mniLR <- readNIfTI(urlfile)
cal.max(mniLR)
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
ANALYZE 7.5\cr
\url{https://rportal.mayo.edu/bir/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}

