% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{check_quality}
\alias{check_quality}
\title{Check Article Class}
\usage{
check_quality(project, edits, ...)
}
\arguments{
\item{project}{a Wikimedia project. Supported projects can be obtained with
\code{\link{list_wikis}}. If NULL (the default), model information will be
retrieved for all projects.}

\item{edits}{a vector of edit IDs, as integers.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
A data.frame of nine columns; \code{edit}, the
edit ID, \code{project}, the project, \code{prediction},
the class that the model predicts the article has, and then one column
each for the probability of the article being in each possible class.
In the event of an error (due to the edit
not being available) NAs will be returned in that row.
}
\description{
\code{check_quality} identifies the quality class of the
article at the moment a particular edit was made.
}
\examples{
# A simple, single-diff example
article_class <- check_quality("enwiki", 34854345)

}
\seealso{
\code{\link{check_goodfaith}} to identify if a set of edits were made
in good faith, \code{\link{check_damaging}} to see if a set of edits caused harm,
and \code{\link{check_reverted}} to check if a set of edits
are likely to be reverted.
}
