% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-stats-lm.r
\name{methods-lm}
\alias{methods-lm}
\alias{as_tbl_ord.lm}
\alias{recover_rows.lm}
\alias{recover_cols.lm}
\alias{recover_coord.lm}
\alias{recover_aug_rows.lm}
\alias{recover_aug_cols.lm}
\alias{recover_aug_coord.lm}
\alias{recover_aug_rows.glm}
\alias{recover_rows.mlm}
\alias{recover_cols.mlm}
\alias{recover_coord.mlm}
\alias{recover_aug_rows.mlm}
\alias{recover_aug_cols.mlm}
\alias{recover_aug_coord.mlm}
\title{Functionality for linear model objects}
\usage{
\method{as_tbl_ord}{lm}(x)

\method{recover_rows}{lm}(x)

\method{recover_cols}{lm}(x)

\method{recover_coord}{lm}(x)

\method{recover_aug_rows}{lm}(x)

\method{recover_aug_cols}{lm}(x)

\method{recover_aug_coord}{lm}(x)

\method{recover_aug_rows}{glm}(x)

\method{recover_rows}{mlm}(x)

\method{recover_cols}{mlm}(x)

\method{recover_coord}{mlm}(x)

\method{recover_aug_rows}{mlm}(x)

\method{recover_aug_cols}{mlm}(x)

\method{recover_aug_coord}{mlm}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"lm"}, \code{"glm"}, and \code{"mlm"} as returned by \code{\link[stats:lm]{stats::lm()}}
and \code{\link[stats:glm]{stats::glm()}}.
}
\examples{
# Motor Trend design and performance data
head(mtcars)
# regression analysis of performance measures on design specifications
mtcars_centered <- scale(mtcars, scale = FALSE)
mtcars_centered \%>\%
  as.data.frame() \%>\%
  lm(formula = mpg ~ wt + cyl) \%>\%
  print() -> mtcars_lm

# wrap as a 'tbl_ord' object
(mtcars_lm_ord <- as_tbl_ord(mtcars_lm))
# augment everything with names, predictors with observation stats
augment_ord(mtcars_lm_ord)
# calculate influences as the squares of weighted residuals
mutate_rows(augment_ord(mtcars_lm_ord), influence = wt.res^2)

# regression biplot with performance isolines
mtcars_lm_ord \%>\%
  augment_ord() \%>\%
  mutate_cols(center = attr(mtcars_centered, "scaled:center")[name]) \%>\%
  mutate_rows(influence = wt.res^2) \%T>\% print() \%>\%
  ggbiplot(aes(x = wt, y = cyl, intercept = `(Intercept)`)) +
  #theme_biplot() +
  geom_origin(marker = "circle", radius = unit(0.02, "snpc")) +
  geom_rows_point(aes(color = influence)) +
  geom_cols_vector() +
  geom_cols_isoline(aes(center = center), by = .5, hjust = -.1) +
  ggtitle(
    "Weight isolines with data colored by importance",
    "Regressing gas mileage onto weight and number of cylinders"
  )
}
\seealso{
Other methods for idiosyncratic techniques: 
\code{\link{methods-kmeans}}

Other models from the stats package: 
\code{\link{methods-cancor}},
\code{\link{methods-cmds}},
\code{\link{methods-factanal}},
\code{\link{methods-kmeans}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}}
}
\concept{methods for idiosyncratic techniques}
\concept{models from the stats package}
