% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TextExtraction.R
\name{extractText}
\alias{extractText}
\title{Extracts the text from a PDF file}
\usage{
extractText(file)
}
\arguments{
\item{file}{Path to the PDF file}
}
\value{
List including the extracted text, a data table including the lines, a data table including the words, the type and language of the document.
}
\description{
This function extracts text from PDF documents and returns the text as a string,
as a list of lines and as a list of words. It uses 'pdftools' to extract the
content from textual PDF files and 'tesseract' to extract the content from
image-based PDF-files.
}
\examples{
file <- system.file("extdata", "OrderDocument_en.pdf", package = "orderanalyzer")
text <- extractText(file)
text$words

}
