// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Definitions and data structures for common layer 2.
use shared::guiddef::GUID;
use shared::minwindef::DWORD;
use um::winnt::PVOID;
pub const L2_PROFILE_MAX_NAME_LENGTH: usize = 256;
pub const L2_NOTIFICATION_SOURCE_NONE: DWORD = 0;
pub const L2_NOTIFICATION_SOURCE_DOT3_AUTO_CONFIG: DWORD = 0x00000001;
pub const L2_NOTIFICATION_SOURCE_SECURITY: DWORD = 0x00000002;
pub const L2_NOTIFICATION_SOURCE_ONEX: DWORD = 0x00000004;
pub const L2_NOTIFICATION_SOURCE_WLAN_ACM: DWORD = 0x00000008;
pub const L2_NOTIFICATION_SOURCE_WLAN_MSM: DWORD = 0x00000010;
pub const L2_NOTIFICATION_SOURCE_WLAN_SECURITY: DWORD = 0x00000020;
pub const L2_NOTIFICATION_SOURCE_WLAN_IHV: DWORD = 0x00000040;
pub const L2_NOTIFICATION_SOURCE_WLAN_HNWK: DWORD = 0x00000080;
pub const L2_NOTIFICATION_SOURCE_WCM: DWORD = 0x00000100;
pub const L2_NOTIFICATION_SOURCE_WCM_CSP: DWORD = 0x00000200;
pub const L2_NOTIFICATION_SOURCE_WFD: DWORD = 0x00000400;
pub const L2_NOTIFICATION_SOURCE_ALL: DWORD = 0x0000ffff;
pub const L2_NOTIFICATION_CODE_PUBLIC_BEGIN: DWORD = 0x00000000;
pub const L2_NOTIFICATION_CODE_GROUP_SIZE: DWORD = 0x00001000;
pub const L2_NOTIFICATION_CODE_V2_BEGIN: DWORD = L2_NOTIFICATION_CODE_PUBLIC_BEGIN
    + L2_NOTIFICATION_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_GROUP_SIZE: u32 = 0x10000;
pub const L2_REASON_CODE_GEN_BASE: u32 = 0x10000;
pub const L2_REASON_CODE_DOT11_AC_BASE: u32 = L2_REASON_CODE_GEN_BASE + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_DOT11_MSM_BASE: u32 = L2_REASON_CODE_DOT11_AC_BASE
    + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_DOT11_SECURITY_BASE: u32 = L2_REASON_CODE_DOT11_MSM_BASE
    + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_ONEX_BASE: u32 = L2_REASON_CODE_DOT11_SECURITY_BASE
    + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_DOT3_AC_BASE: u32 = L2_REASON_CODE_ONEX_BASE
    + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_DOT3_MSM_BASE: u32 = L2_REASON_CODE_DOT3_AC_BASE
    + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_PROFILE_BASE: u32 = L2_REASON_CODE_DOT3_MSM_BASE
    + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_IHV_BASE: u32 = L2_REASON_CODE_PROFILE_BASE + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_WIMAX_BASE: u32 = L2_REASON_CODE_IHV_BASE + L2_REASON_CODE_GROUP_SIZE;
pub const L2_REASON_CODE_SUCCESS: u32 = 0;
pub const L2_REASON_CODE_UNKNOWN: u32 = L2_REASON_CODE_GEN_BASE + 1;
pub const L2_REASON_CODE_PROFILE_MISSING: u32 = 0x00000001;
STRUCT!{struct L2_NOTIFICATION_DATA {
    NotificationSource: DWORD,
    NotificationCode: DWORD,
    InterfaceGuid: GUID,
    dwDataSize: DWORD,
    pData: PVOID,
}}
pub type PL2_NOTIFICATION_DATA = *mut L2_NOTIFICATION_DATA;
