% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optics_plots.R
\name{ggplot_optics}
\alias{ggplot_optics}
\title{Ggplot optics}
\usage{
ggplot_optics(optics_obj, groups = NULL, colors = if (!is.null(groups))
  nice_palette(groups), segment_size = 300/nrow(df_optics))
}
\arguments{
\item{optics_obj}{dbscan::optics object}

\item{groups}{Optional vector defining groups of OPTICS observations}

\item{colors}{If groups specified, vector of colors for each group}

\item{segment_size}{Size for geom_segment}
}
\value{
ggplot
}
\description{
Plot OPTICS reachability plot.
}
\examples{
data('multishapes')
optics_obj <- dbscan::optics(multishapes[1:2])
ggplot_optics(optics_obj)
ggplot_optics(optics_obj,
  groups = opticskxi(optics_obj, n_xi = 5, pts = 30))
}
\seealso{
\link{opticskxi}
}
