% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opi_impact.R
\name{opi_impact}
\alias{opi_impact}
\title{Impact analysis of subject B on the opinion expressed
concerning subject A in a text document}
\usage{
opi_impact(textdoc, sec_keywords=NULL, metric = 1,
fun = NULL, nsim = 99, alternative="two.sided",
quiet=TRUE)
}
\arguments{
\item{textdoc}{An \code{n} x \code{1} list (dataframe) of
individual text records, where \code{n} is the total
number of individual records.}

\item{sec_keywords}{(a list) A one-column dataframe (of any
number of length) containing a list of keywords relating
to the secondary subject (subject \code{B}).}

\item{metric}{(an integer) Specify the metric to utilize
for the calculation of opinion score. Default: \code{1}.
See detailed documentation
in the \code{opi_score} function.}

\item{fun}{A user-defined function given that parameter
\code{metric} (above) is set equal to \code{5}.
See detailed documentation
in the \code{opi_score} function.}

\item{nsim}{(an integer) Number of replicas (ESD) to generate.
See detailed documentation in the \code{opi_sim} function.
Default: \code{99}.}

\item{alternative}{(a character) Default: \code{"two.sided"},
indicating a two-tailed test. A user can override
this default value by specifying \code{“less”} or \code{“greater”}
to run the analysis as one-tailed test when the observed score
is located at the lower or upper regions of the expectation
distribution, respectively. Note: for \code{metric=1},
the \code{alternative} parameter should be
set equal to \code{"two.sided"} because the opinion score is
bounded by both positive and negative values. For an opinion
score bounded by positive values, such as when
\code{metric = 2, 3 or 4}, the \code{alternative} parameter
should be set as "greater", and set as "less" otherwise.
If metric parameter is set equal to \code{5}, with a user-defined
opinion score function (i.e. \code{fun} not NULL ), the user is required
to determine the boundary of the opinion scores, and set the
\code{alternative} argument appropriately.}

\item{quiet}{(TRUE or FALSE) To suppress processing
messages. Default: \code{TRUE}.}
}
\value{
Details of statistical significance of impacts
of a secondary subject \code{B} on the opinion concerning the
primary subject \code{A}.
}
\description{
This function assesses the impacts of a subject
B (a secondary subject) on the opinion concerning subject A
(the primary subject) in a text document. Keywords relating
to the secondary subject, can be identified  using any
analytical techniques, such as the frequency analysis.
The keywords should then be collated provide as input into
this function (see below). The subject A (primary subject)
is usually the main theme of the text document. For instance,
by downloading Twitter data that include a set of related
hashtags; e.g. ’#police’, ’#policing’ and/or ’#law enforcement’,
then "Police or Policing" forms the primary subject of the
downloaded text document.
}
\details{
This function calculates the statistical
significance value (\code{p-value}) of an opinion score
by comparing the observed score (from the \code{opi_score}
function) with the expected scores (distribution) (from the
\code{opi_sim} function). The formula is given as
\code{p = (S.beat+1)/(S.total+1)}, where \code{S_total} is the total
number of replicas (\code{nsim}) specified, \code{S.beat} is number of replicas
in which their expected scores are than the observed score (See
further details in Adepeju and Jimoh, 2021).
}
\examples{
#test document: 'policing_otd'
#list of keywords: 'covid_keys'

output <- opi_impact(textdoc = policing_otd,
          sec_keywords=covid_keys, metric = 1,
          fun = NULL, nsim = 99, alternative="two.sided",
          quiet=TRUE)

#check output variables
print(output)

#to access the pvalue
output$pvalue

}
\references{
(1) Adepeju, M. and Jimoh, F. (2021). An Analytical
Framework for Measuring Inequality in the Public Opinions on
Policing – Assessing the impacts of COVID-19 Pandemic using
Twitter Data. https://doi.org/10.31235/osf.io/c32qh
}
