% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{sheet_visibility}
\alias{sheet_visibility}
\alias{wb_get_sheet_visibility}
\alias{wb_set_sheet_visibility}
\title{Get/set worksheet visible state}
\usage{
wb_get_sheet_visibility(wb)

wb_set_sheet_visibility(wb, sheet = current_sheet(), value)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object}

\item{sheet}{Worksheet identifier}

\item{value}{a logical/character vector the same length as sheet}
}
\value{
Character vector of worksheet names.

Vector of "hidden", "visible", "veryHidden"
}
\description{
Get and set worksheet visible state
}
\examples{

wb <- wb_workbook()
wb$add_worksheet(sheet = "S1", visible = FALSE)
wb$add_worksheet(sheet = "S2", visible = TRUE)
wb$add_worksheet(sheet = "S3", visible = FALSE)

wb$get_sheet_visibility()
wb$set_sheet_visibility(1, TRUE)         ## show sheet 1
wb$set_sheet_visibility(2, FALSE)        ## hide sheet 2
wb$set_sheet_visibility(3, "hidden")     ## hide sheet 3
wb$set_sheet_visibility(3, "veryHidden") ## hide sheet 3 from UI
}
