% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_header_footer}
\alias{wb_set_header_footer}
\title{Set document headers and footers}
\usage{
wb_set_header_footer(
  wb,
  sheet = current_sheet(),
  header = NULL,
  footer = NULL,
  evenHeader = NULL,
  evenFooter = NULL,
  firstHeader = NULL,
  firstFooter = NULL
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{header}{document header. Character vector of length 3 corresponding to positions left, center, right. Use NA to skip a position.}

\item{footer}{document footer. Character vector of length 3 corresponding to positions left, center, right. Use NA to skip a position.}

\item{evenHeader}{document header for even pages.}

\item{evenFooter}{document footer for even pages.}

\item{firstHeader}{document header for first page only.}

\item{firstFooter}{document footer for first page only.}
}
\description{
Set document headers and footers
}
\details{
Headers and footers can contain special tags
\itemize{
\item{\strong{&[Page]}}{ Page number}
\item{\strong{&[Pages]}}{ Number of pages}
\item{\strong{&[Date]}}{ Current date}
\item{\strong{&[Time]}}{ Current time}
\item{\strong{&[Path]}}{ File path}
\item{\strong{&[File]}}{ File name}
\item{\strong{&[Tab]}}{ Worksheet name}
}
}
\examples{
wb <- wb_workbook()

wb$add_worksheet("S1")
wb$add_worksheet("S2")
wb$add_worksheet("S3")
wb$add_worksheet("S4")

wb$add_data(1, 1:400)
wb$add_data(2, 1:400)
wb$add_data(3, 3:400)
wb$add_data(4, 3:400)

wb$set_header_footer(
  sheet = "S1",
  header = c("ODD HEAD LEFT", "ODD HEAD CENTER", "ODD HEAD RIGHT"),
  footer = c("ODD FOOT RIGHT", "ODD FOOT CENTER", "ODD FOOT RIGHT"),
  evenHeader = c("EVEN HEAD LEFT", "EVEN HEAD CENTER", "EVEN HEAD RIGHT"),
  evenFooter = c("EVEN FOOT RIGHT", "EVEN FOOT CENTER", "EVEN FOOT RIGHT"),
  firstHeader = c("TOP", "OF FIRST", "PAGE"),
  firstFooter = c("BOTTOM", "OF FIRST", "PAGE")
)

wb$set_header_footer(
  sheet = 2,
  header = c("&[Date]", "ALL HEAD CENTER 2", "&[Page] / &[Pages]"),
  footer = c("&[Path]&[File]", NA, "&[Tab]"),
  firstHeader = c(NA, "Center Header of First Page", NA),
  firstFooter = c(NA, "Center Footer of First Page", NA)
)

wb$set_header_footer(
  sheet = 3,
  header = c("ALL HEAD LEFT 2", "ALL HEAD CENTER 2", "ALL HEAD RIGHT 2"),
  footer = c("ALL FOOT RIGHT 2", "ALL FOOT CENTER 2", "ALL FOOT RIGHT 2")
)

wb$set_header_footer(
  sheet = 4,
  firstHeader = c("FIRST ONLY L", NA, "FIRST ONLY R"),
  firstFooter = c("FIRST ONLY L", NA, "FIRST ONLY R")
)
}
\seealso{
\code{\link[=wb_add_worksheet]{wb_add_worksheet()}} to set headers and footers when adding a worksheet
}
