% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_form_control}
\alias{wb_add_form_control}
\title{Add form control Checkbox, Radiobuttons or Dropmenu}
\usage{
wb_add_form_control(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  type = NULL,
  text = NULL,
  link = NULL,
  range = NULL,
  checked = FALSE
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A worksheet of the workbook}

\item{dims}{Optional row and column as spreadsheet dimension, e.g. "A1"}

\item{type}{A type "Checkbox" (the default), "Radio" a radio button or "Drop" a drop down menu}

\item{text}{A text to be shown next to the Checkbox or radio button}

\item{link}{A cell range to link to}

\item{range}{A cell range used as input}

\item{checked}{A logical indicating if the Checkbox or radio button is checked}
}
\value{
The \code{wbWorkbook} object
}
\description{
Add form control Checkbox, Radiobuttons or Dropmenu
}
\examples{
wb <- wb_workbook() \%>\% wb_add_worksheet() \%>\%
  wb_add_form_control()
}
