% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_dxfs_style}
\alias{create_dxfs_style}
\title{Create a custom formatting style}
\usage{
create_dxfs_style(
  font_name = "Calibri",
  font_size = "11",
  font_color = wb_colour(hex = "FF9C0006"),
  numFmt = NULL,
  border = NULL,
  border_color = wb_colour(getOption("openxlsx2.borderColour", "black")),
  border_style = getOption("openxlsx2.borderStyle", "thin"),
  bgFill = wb_colour(hex = "FFFFC7CE"),
  text_bold = NULL,
  text_strike = NULL,
  text_italic = NULL,
  text_underline = NULL
)
}
\arguments{
\item{font_name}{A name of a font. Note the font name is not validated. If fontName is NULL,
the workbook base font is used. (Defaults to Calibri)}

\item{font_size}{Font size. A numeric greater than 0.
If fontSize is NULL, the workbook base font size is used. (Defaults to 11)}

\item{font_color}{Colour of text in cell.  A valid hex colour beginning with "#"
or one of colours(). If fontColour is NULL, the workbook base font colours is used.
(Defaults to black)}

\item{numFmt}{Cell formatting. Some custom openxml format}

\item{border}{NULL or TRUE}

\item{border_color}{"black"}

\item{border_style}{"thin"}

\item{bgFill}{Cell background fill color.}

\item{text_bold}{bold}

\item{text_strike}{strikeout}

\item{text_italic}{italic}

\item{text_underline}{underline 1, true, single or double}
}
\value{
A dxfs style node
}
\description{
Create a new style to apply to worksheet cells
}
\examples{
## See package vignettes for further examples
}
