% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_windroseMap.R
\name{windroseMap}
\alias{windroseMap}
\title{Wind roses on dynamic and static maps}
\usage{
windroseMap(
  data,
  ws.int = 2,
  breaks = 4,
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  type = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  legend = TRUE,
  legend.position = NULL,
  legend.title = NULL,
  legend.title.autotext = TRUE,
  control.collapsed = FALSE,
  control.position = "topright",
  control.autotext = TRUE,
  d.icon = 200,
  d.fig = 3.5,
  static = FALSE,
  static.nrow = NULL,
  ...,
  control = NULL
)
}
\arguments{
\item{data}{\emph{Input data table with wind and geo-spatial information.}

\strong{required} | \emph{scope:} dynamic & static

A data frame. The data frame must contain the data to plot the directional
analysis marker, which includes wind speed (\code{ws}) and wind direction
(\code{wd}). In addition, \code{data} must include a decimal latitude and longitude
(or X/Y coordinate used in conjunction with \code{crs}).}

\item{ws.int}{\emph{The wind speed interval of the colour axis.}

\emph{default:} \code{2} | \emph{scope:} dynamic & static

The wind speed interval. Default is 2 m/s but for low met masts with low
mean wind speeds a value of 1 or 0.5 m/s may be better.}

\item{breaks}{\emph{Specifier for the number of breaks of the colour axis.}

\emph{default:} \code{4} | \emph{scope:} dynamic & static

Most commonly, the number of break points for wind speed in
\code{\link[openair:windRose]{openair::windRose()}}. For the \code{ws.int} default of \code{2}, the default
\code{breaks}, \code{4}, generates the break points 2, 4, 6, and 8. Breaks can also
be used to set specific break points. For example, the argument `breaks =
c(0, 1, 10, 100)`` breaks the data into segments <1, 1-10, 10-100, >100.}

\item{latitude, longitude}{\emph{The decimal latitude(Y)/longitude(X).}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Column names representing the decimal latitude and longitude (or other Y/X
coordinate if using a different \code{crs}). If not provided, will be
automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{crs}{\emph{The coordinate reference system (CRS).}

\emph{default:} \code{4326} | \emph{scope:} dynamic & static

The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for
plotting on the map.}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Used for splitting the input data into different groups, passed to the
\code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. When \code{type} is specified:
\itemize{
\item \emph{Dynamic}: The different data splits can be toggled between using a "layer control" menu.
\item \emph{Static:}: The data splits will each appear in a different panel.
}

\code{type} cannot be used if multiple \code{pollutant} columns have been provided.}

\item{popup}{\emph{Content for marker popups on dynamic maps.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic

Columns to be used as the HTML content for marker popups on dynamic maps.
Popups may be useful to show information about the individual sites (e.g.,
site names, codes, types, etc.). If a vector of column names are provided
they are passed to \code{\link[=buildPopup]{buildPopup()}} using its default values.}

\item{label}{\emph{Content for marker hover-over on dynamic maps.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic

Column to be used as the HTML content for hover-over labels. Labels are
useful for the same reasons as popups, though are typically shorter.}

\item{provider}{\emph{The basemap(s) to be used.}

\emph{default:} \code{"OpenStreetMap"} | \emph{scope:} dynamic & static

The base map(s) to be used beneath the polar markers. If not provided, will
default to \code{"OpenStreetMap"}/\code{"osm"} for both dynamic and static maps.
\itemize{
\item \emph{Dynamic}: Any number of \link[leaflet:providers]{leaflet::providers}.
See \url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface. By default, the
interface will use the provider names as labels, but users can define their
own using a named vector (e.g., \code{c("Default" = "OpenStreetMap", "Satellite"   = "Esri.WorldImagery")})
\item \emph{Static}: One of \code{\link[rosm:deprecated]{rosm::osm.types()}}.
}

There is some overlap in static and dynamic providers. For example,
\code{{ggspatial}} uses "osm" to specify "OpenStreetMap". When static providers
are provided to dynamic maps or vice versa, \code{{openairmaps}} will attempt to
substitute the correct provider string.}

\item{cols}{\emph{Colours to use for plotting.}

\emph{default:} \code{"turbo"} | \emph{scope:} dynamic & static

The colours used for plotting, passed to \code{\link[openair:openColours]{openair::openColours()}}. The
default, \code{"turbo"}, is a rainbow palette with relatively perceptually
uniform colours. Read more about this palette at
\url{https://research.google/blog/turbo-an-improved-rainbow-colormap-for-visualization/}.}

\item{alpha}{\emph{Transparency value for polar markers.}

\emph{default:} \code{1} | \emph{scope:} dynamic & static

A value between 0 (fully transparent) and 1 (fully opaque).}

\item{key}{\emph{Draw individual marker legends?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic & static

Draw a key for each individual marker? Potentially useful when \code{limits = "free"}, but of limited use otherwise.}

\item{legend}{\emph{Draw a shared legend?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

When all markers share the same colour scale (e.g., when \code{limits != "free"}
in \code{\link[=polarMap]{polarMap()}}), should a shared legend be created at the side of the map?}

\item{legend.position}{\emph{Position of the shared legend.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

When \code{legend = TRUE}, where should the legend be placed?
\itemize{
\item \emph{Dynamic}: One of "topright", "topright", "bottomleft" or "bottomright". Passed to the \code{position} argument of \code{\link[leaflet:addLegend]{leaflet::addLegend()}}.
\item \emph{Static:}: One of "top", "right", "bottom" or "left". Passed to the \code{legend.position} argument of \code{\link[ggplot2:theme]{ggplot2::theme()}}.
}}

\item{legend.title}{\emph{Title of the legend.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

By default, when \code{legend.title = NULL}, the function will attempt to
provide a sensible legend title. \code{legend.title} allows users to overwrite
this - for example, to include units or other contextual information. For
\emph{dynamic} maps, users may wish to use HTML tags to format the title.}

\item{legend.title.autotext}{\emph{Automatically format the title of the legend?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

When \code{legend.title.autotext = TRUE}, \code{legend.title} will be first run
through \code{\link[=quickTextHTML]{quickTextHTML()}} (\emph{dynamic}) or \code{\link[openair:quickText]{openair::quickText()}} (\emph{static}).}

\item{control.collapsed}{\emph{Show the layer control as a collapsed?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic

For \emph{dynamic} maps, should the "layer control" interface be collapsed? If
\code{TRUE}, users will have to hover over an icon to view the options.}

\item{control.position}{\emph{Position of the layer control menu}

\emph{default:} \code{"topright"} | \emph{scope:} dynamic

When \code{type != NULL}, or multiple pollutants are specified, where should the
"layer control" interface be placed? One of "topleft", "topright",
"bottomleft" or "bottomright". Passed to the \code{position} argument of
\code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}}.}

\item{control.autotext}{\emph{Automatically format the content of the layer
control menu?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic

When \code{control.autotext = TRUE}, the content of the "layer control"
interface will be first run through \code{\link[=quickTextHTML]{quickTextHTML()}}.}

\item{d.icon}{\emph{The diameter of the plot on the map in pixels.}

\emph{default:} \code{200} | \emph{scope:} dynamic & static

This will affect the size of the individual polar markers. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{d.fig}{\emph{The diameter of the plots to be produced using \code{{openair}} in
inches.}

\emph{default:} \code{3.5} | \emph{scope:} dynamic & static

This will affect the resolution of the markers on the map. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{static}{\emph{Produce a static map?}

\emph{default:} \code{FALSE}

This controls whether a \emph{dynamic} or \emph{static} map is produced. The former
is the default and is broadly more useful, but the latter may be preferable
for DOCX or PDF outputs (e.g., academic papers).}

\item{static.nrow}{\emph{Number of rows in a static map.}

\emph{default:} \code{NULL} | \emph{scope:} static

Controls the number of rows of panels on a static map when multiple
\code{pollutant}s or \code{type} are specified; passed to the \code{nrow} argument of
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. The default, \code{NULL}, results in a roughly square
grid of panels.}

\item{...}{
  Arguments passed on to \code{\link[openair:windRose]{openair::windRose}}
  \describe{
    \item{\code{ws}}{Name of the column representing wind speed.}
    \item{\code{wd}}{Name of the column representing wind direction.}
    \item{\code{ws2,wd2}}{The user can supply a second set of wind speed and wind
direction values with which the first can be compared. See
\code{\link[openair:pollutionRose]{pollutionRose()}} for more details.}
    \item{\code{angle}}{Default angle of \dQuote{spokes} is 30. Other potentially useful
angles are 45 and 10. Note that the width of the wind speed interval may
need adjusting using \code{width}.}
    \item{\code{bias.corr}}{When \code{angle} does not divide exactly into 360 a bias is
introduced in the frequencies when the wind direction is already supplied
rounded to the nearest 10 degrees, as is often the case. For example, if
\code{angle = 22.5}, N, E, S, W will include 3 wind sectors and all other
angles will be two. A bias correction can made to correct for this problem.
A simple method according to Applequist (2012) is used to adjust the
frequencies.}
    \item{\code{grid.line}}{Grid line interval to use. If \code{NULL}, as in default,
this is assigned based on the available data range. However, it can also be
forced to a specific value, e.g. \code{grid.line = 10}. \code{grid.line}
can also be a list to control the interval, line type and colour. For
example \code{grid.line = list(value = 10, lty = 5, col = "purple")}.}
    \item{\code{width}}{For \code{paddle = TRUE}, the adjustment factor for width of
wind speed intervals. For example, \code{width = 1.5} will make the paddle
width 1.5 times wider.}
    \item{\code{seg}}{When \code{paddle = TRUE}, \code{seg} determines with width of the
segments. For example, \code{seg = 0.5} will produce segments 0.5 *
\code{angle}.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly, e.g., by subscripting the \sQuote{2} in NO2.}
    \item{\code{offset}}{The size of the 'hole' in the middle of the plot, expressed as
a percentage of the polar axis scale, default 10.}
    \item{\code{normalise}}{If \code{TRUE} each wind direction segment is normalised to
equal one. This is useful for showing how the concentrations (or other
parameters) contribute to each wind sector when the proportion of time the
wind is from that direction is low. A line showing the probability that the
wind directions is from a particular wind sector is also shown.}
    \item{\code{max.freq}}{Controls the scaling used by setting the maximum value for
the radial limits. This is useful to ensure several plots use the same
radial limits.}
    \item{\code{paddle}}{Either \code{TRUE} or \code{FALSE}. If \code{TRUE} plots rose
using 'paddle' style spokes. If \code{FALSE} plots rose using 'wedge' style
spokes.}
    \item{\code{key.header}}{Adds additional text/labels above the scale key. For
example, passing \code{windRose(mydata, key.header = "ws")} adds the
addition text as a scale header. Note: This argument is passed to
\code{\link[openair:drawOpenKey]{drawOpenKey()}} via \code{\link[openair:quickText]{quickText()}}, applying the auto.text argument, to
handle formatting.}
    \item{\code{key.footer}}{Adds additional text/labels below the scale key. See
\code{key.header} for further information.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \dQuote{top}, \dQuote{right}, \dQuote{bottom}
and \dQuote{left}.}
    \item{\code{dig.lab}}{The number of significant figures at which scientific number
formatting is used in break point and key labelling. Default 5.}
    \item{\code{include.lowest}}{Logical. If \code{FALSE} (the default), the first
interval will be left exclusive and right inclusive. If \code{TRUE}, the
first interval will be left and right inclusive. Passed to the
\code{include.lowest} argument of \code{\link[=cut]{cut()}}.}
    \item{\code{statistic}}{The \code{statistic} to be applied to each data bin in the
plot. Options currently include \dQuote{prop.count}, \dQuote{prop.mean} and
\dQuote{abs.count}. The default \dQuote{prop.count} sizes bins according to
the proportion of the frequency of measurements.  Similarly,
\dQuote{prop.mean} sizes bins according to their relative contribution to
the mean. \dQuote{abs.count} provides the absolute count of measurements in
each bin.}
    \item{\code{pollutant}}{Alternative data series to be sampled instead of wind speed.
The \code{\link[openair:windRose]{windRose()}} default NULL is equivalent to \code{pollutant = "ws"}. Use
in \code{\link[openair:pollutionRose]{pollutionRose()}}.}
    \item{\code{angle.scale}}{The scale is by default shown at a 315 degree angle.
Sometimes the placement of the scale may interfere with an interesting
feature. The user can therefore set \code{angle.scale} to another value
(between 0 and 360 degrees) to mitigate such problems. For example
\code{angle.scale = 45} will draw the scale heading in a NE direction.}
    \item{\code{border}}{Border colour for shaded areas. Default is no border.}
  }}

\item{control}{\strong{Deprecated.} Please use \code{type}.}
}
\value{
Either:
\itemize{
\item \emph{Dynamic:} A leaflet object
\item \emph{Static:} A \code{ggplot2} object using \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} coordinates with a \code{ggspatial} basemap
}
}
\description{
The \code{\link[=windroseMap]{windroseMap()}} function creates a map using wind roses as markers.
Multiple layers of markers can be created using the \code{type} argument. By
default, these maps are dynamic and can be panned, zoomed, and otherwise
interacted with. Using the \code{static} argument allows for static images to be
produced instead.
}
\section{Customisation of static maps using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\examples{
\dontrun{
windroseMap(polar_data,
  provider = "CartoDB.Voyager"
)
}
}
\seealso{
\code{\link[openair:windRose]{openair::windRose()}}

Other directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{diffMap}()},
\code{\link{freqMap}()},
\code{\link{percentileMap}()},
\code{\link{polarMap}()},
\code{\link{pollroseMap}()}
}
\concept{directional analysis maps}
