% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarMap.R
\name{polarMap}
\alias{polarMap}
\title{Bivariate polar plots on interactive leaflet maps}
\usage{
polarMap(
  data,
  pollutant = NULL,
  x = "ws",
  limits = NULL,
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  draw.legend = TRUE,
  collapse.control = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 3.5,
  fig.height = 3.5,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{x}{The radial axis variable to plot.}

\item{limits}{By default, each individual polar marker has its own colour
scale. The \code{limits} argument will force all markers to use the same
colour scale. The limits are set in the form \code{c(lower, upper)}, so
\code{limits = c(0, 100)} would force the plot limits to span 0-100.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or
"lon"/"lng"/"long"/"longitude"
(case-insensitively).}

\item{control}{Column to be used for splitting the input data into different
groups which can be selected between using a "layer control" interface.
Appropriate columns could be those added by \code{\link[openair:cutData]{openair::cutData()}} or
\code{\link[openair:splitByDate]{openair::splitByDate()}}. \code{control} cannot be used if multiple
\code{pollutant} columns have been provided.}

\item{popup}{Column to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.).}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{cols}{The colours used for plotting.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{draw.legend}{When \code{limits} are specified, should a shared legend
be created at the side of the map? Default is \code{TRUE}.}

\item{collapse.control}{Should the "layer control" interface be collapsed?
Defaults to \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{type}{Deprecated. Please use \code{label} and/or \code{popup} to label
different sites.}

\item{...}{
  Arguments passed on to \code{\link[openair:polarPlot]{openair::polarPlot}}
  \describe{
    \item{\code{wd}}{Name of wind direction field.}
    \item{\code{statistic}}{The statistic that should be applied to each wind
speed/direction bin. Because of the smoothing involved, the colour scale
for some of these statistics is only to provide an indication of overall
pattern and should not be interpreted in concentration units e.g. for
\code{statistic = "weighted.mean"} where the bin mean is multiplied by the
bin frequency and divided by the total frequency. In many cases using
\code{polarFreq} will be better. Setting \code{statistic = "weighted.mean"}
can be useful because it provides an indication of the concentration *
frequency of occurrence and will highlight the wind speed/direction
conditions that dominate the overall mean.Can be:

\itemize{ \item  \dQuote{mean} (default), \dQuote{median}, \dQuote{max}
(maximum), \dQuote{frequency}. \dQuote{stdev} (standard deviation),
\dQuote{weighted.mean}.

\item \code{statistic = "nwr"} Implements the Non-parametric Wind
Regression approach of Henry et al. (2009) that uses kernel smoothers. The
\code{openair} implementation is not identical because Gaussian kernels are
used for both wind direction and speed. The smoothing is controlled by
\code{ws_spread} and \code{wd_spread}.

\item \code{statistic = "cpf"} the conditional probability function (CPF)
is plotted and a single (usually high) percentile level is supplied. The
CPF is defined as CPF = my/ny, where my is the number of samples in the y
bin (by default a wind direction, wind speed interval) with mixing ratios
greater than the \emph{overall} percentile concentration, and ny is the
total number of samples in the same wind sector (see Ashbaugh et al.,
1985). Note that percentile intervals can also be considered; see
\code{percentile} for details.

\item When \code{statistic = "r"} or \code{statistic = "Pearson"}, the
Pearson correlation coefficient is calculated for \emph{two} pollutants.
The calculation involves a weighted Pearson correlation coefficient, which
is weighted by Gaussian kernels for wind direction an the radial variable
(by default wind speed). More weight is assigned to values close to a wind
speed-direction interval. Kernel weighting is used to ensure that all data
are used rather than relying on the potentially small number of values in a
wind speed-direction interval.

\item When \code{statistic = "Spearman"}, the Spearman correlation
coefficient is calculated for \emph{two} pollutants. The calculation
involves a weighted Spearman correlation coefficient, which is weighted by
Gaussian kernels for wind direction an the radial variable (by default wind
speed). More weight is assigned to values close to a wind speed-direction
interval. Kernel weighting is used to ensure that all data are used rather
than relying on the potentially small number of values in a wind
speed-direction interval.

\item \code{"robust_slope"} is another option for pair-wise statistics and
\code{"quantile.slope"}, which uses quantile regression to estimate the
slope for a particular quantile level (see also \code{tau} for setting the
quantile level).

\item \code{"york_slope"} is another option for pair-wise statistics which
uses the \emph{York regression method} to estimate the slope. In this
method the uncertainties in \code{x} and \code{y} are used in the
determination of the slope. The uncertainties are provided by
\code{x_error} and \code{y_error} --- see below.}}
    \item{\code{exclude.missing}}{Setting this option to \code{TRUE} (the default)
removes points from the plot that are too far from the original data. The
smoothing routines will produce predictions at points where no data exist
i.e. they predict. By removing the points too far from the original data
produces a plot where it is clear where the original data lie. If set to
\code{FALSE} missing data will be interpolated.}
    \item{\code{uncertainty}}{Should the uncertainty in the calculated surface be shown?
If \code{TRUE} three plots are produced on the same scale showing the
predicted surface together with the estimated lower and upper uncertainties
at the 95\% confidence interval. Calculating the uncertainties is useful to
understand whether features are real or not.  For example, at high wind
speeds where there are few data there is greater uncertainty over the
predicted values. The uncertainties are calculated using the GAM and
weighting is done by the frequency of measurements in each wind
speed-direction bin. Note that if uncertainties are calculated then the
type is set to "default".}
    \item{\code{percentile}}{If \code{statistic = "percentile"} then \code{percentile}
is used, expressed from 0 to 100. Note that the percentile value is
calculated in the wind speed, wind direction \sQuote{bins}. For this reason
it can also be useful to set \code{min.bin} to ensure there are a
sufficient number of points available to estimate a percentile. See
\code{quantile} for more details of how percentiles are calculated.

\code{percentile} is also used for the Conditional Probability Function
(CPF) plots. \code{percentile} can be of length two, in which case the
percentile \emph{interval} is considered for use with CPF. For example,
\code{percentile = c(90, 100)} will plot the CPF for concentrations between
the 90 and 100th percentiles. Percentile intervals can be useful for
identifying specific sources. In addition, \code{percentile} can also be of
length 3. The third value is the \sQuote{trim} value to be applied. When
calculating percentile intervals many can cover very low values where there
is no useful information. The trim value ensures that values greater than
or equal to the trim * mean value are considered \emph{before} the
percentile intervals are calculated. The effect is to extract more detail
from many source signatures. See the manual for examples. Finally, if the
trim value is less than zero the percentile range is interpreted as
absolute concentration values and subsetting is carried out directly.}
    \item{\code{weights}}{At the edges of the plot there may only be a few data points
in each wind speed-direction interval, which could in some situations
distort the plot if the concentrations are high. \code{weights} applies a
weighting to reduce their influence. For example and by default if only a
single data point exists then the weighting factor is 0.25 and for two
points 0.5. To not apply any weighting and use the data as is, use
\code{weights = c(1, 1, 1)}.

An alternative to down-weighting these points they can be removed
altogether using \code{min.bin}.}
    \item{\code{min.bin}}{The minimum number of points allowed in a wind speed/wind
direction bin.  The default is 1. A value of two requires at least 2 valid
records in each bin an so on; bins with less than 2 valid records are set
to NA. Care should be taken when using a value > 1 because of the risk of
removing real data points. It is recommended to consider your data with
care. Also, the \code{polarFreq} function can be of use in such
circumstances.}
    \item{\code{mis.col}}{When \code{min.bin} is > 1 it can be useful to show where data
are removed on the plots. This is done by shading the missing data in
\code{mis.col}. To not highlight missing data when \code{min.bin} > 1
choose \code{mis.col = "transparent"}.}
    \item{\code{upper}}{This sets the upper limit wind speed to be used. Often there are
only a relatively few data points at very high wind speeds and plotting all
of them can reduce the useful information in the plot.}
    \item{\code{angle.scale}}{Sometimes the placement of the scale may interfere with an
interesting feature. The user can therefore set \code{angle.scale} to
any value between 0 and 360 degrees to mitigate such problems. For
example \code{angle.scale = 45} will draw the scale heading in a NE
direction.}
    \item{\code{units}}{The units shown on the polar axis scale.}
    \item{\code{force.positive}}{The default is \code{TRUE}. Sometimes if smoothing data
with steep gradients it is possible for predicted values to be negative.
\code{force.positive = TRUE} ensures that predictions remain positive. This
is useful for several reasons. First, with lots of missing data more
interpolation is needed and this can result in artefacts because the
predictions are too far from the original data. Second, if it is known
beforehand that the data are all positive, then this option carries that
assumption through to the prediction. The only likely time where setting
\code{force.positive = FALSE} would be if background concentrations were
first subtracted resulting in data that is legitimately negative. For the
vast majority of situations it is expected that the user will not need to
alter the default option.}
    \item{\code{k}}{This is the smoothing parameter used by the \code{gam} function in
package \code{mgcv}. Typically, value of around 100 (the default) seems to
be suitable and will resolve important features in the plot. The most
appropriate choice of \code{k} is problem-dependent; but extensive testing
of polar plots for many different problems suggests a value of \code{k} of
about 100 is suitable. Setting \code{k} to higher values will not tend to
affect the surface predictions by much but will add to the computation
time. Lower values of \code{k} will increase smoothing. Sometimes with few
data to plot \code{polarPlot} will fail. Under these circumstances it can
be worth lowering the value of \code{k}.}
    \item{\code{normalise}}{If \code{TRUE} concentrations are normalised by dividing by
their mean value. This is done \emph{after} fitting the smooth surface.
This option is particularly useful if one is interested in the patterns of
concentrations for several pollutants on different scales e.g. NOx and CO.
Often useful if more than one \code{pollutant} is chosen.}
    \item{\code{key.header}}{Adds additional text/labels to the scale key. For example,
passing the options \code{key.header = "header", key.footer = "footer1"}
adds addition text above and below the scale key. These arguments are
passed to \code{drawOpenKey} via \code{quickText}, applying the
\code{auto.text} argument, to handle formatting.}
    \item{\code{key.footer}}{see \code{key.footer}.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}
and \code{"left"}.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
    \item{\code{ws_spread}}{The value of sigma used for Gaussian kernel weighting of
wind speed when \code{statistic = "nwr"} or when correlation and regression
statistics are used such as \emph{r}. Default is \code{0.5}.}
    \item{\code{wd_spread}}{The value of sigma used for Gaussian kernel weighting of
wind direction when \code{statistic = "nwr"} or when correlation and
regression statistics are used such as \emph{r}. Default is \code{4}.}
    \item{\code{x_error}}{The \code{x} error / uncertainty used when \code{statistic =
"york_slope"}.}
    \item{\code{y_error}}{The \code{y} error / uncertainty used when \code{statistic =
"york_slope"}.}
    \item{\code{kernel}}{Type of kernel used for the weighting procedure for when
correlation or regression techniques are used. Only \code{"gaussian"} is
supported but this may be enhanced in the future.}
    \item{\code{tau}}{The quantile to be estimated when \code{statistic} is set to
\code{"quantile.slope"}. Default is \code{0.5} which is equal to the median
and will be ignored if \code{"quantile.slope"} is not used.}
  }}
}
\value{
A leaflet object.
}
\description{
\code{\link[=polarMap]{polarMap()}} creates a \code{leaflet} map using bivariate polar plots as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be added and toggled between
using \code{control}. See \code{\link[openair:polarPlot]{openair::polarPlot()}} for more information.
}
\examples{
\dontrun{
polarMap(polar_data,
  pollutant = "nox",
  x = "ws",
  provider = "Stamen.Toner"
)
}
}
\seealso{
Other directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{freqMap}()},
\code{\link{percentileMap}()},
\code{\link{pollroseMap}()},
\code{\link{windroseMap}()}
}
\concept{directional analysis maps}
