% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annulusMap.R
\name{annulusMap}
\alias{annulusMap}
\title{Polar annulus plots on interactive leaflet maps}
\usage{
annulusMap(
  data,
  pollutant = "nox",
  period = "hour",
  latitude = "lat",
  longitude = "lon",
  provider = "OpenStreetMap",
  type = "default",
  cols = "jet",
  alpha = 1,
  key = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 4,
  fig.height = 4,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot a
\code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}, which includes wind speed (\code{ws}), wind
direction (\code{wd}), date (\code{date}), and the column representing the
concentration of a pollutant. In addition, \code{data} must include a
decimal latitude and longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{period}{This determines the temporal period to consider. Options are
\dQuote{hour} (the default, to plot diurnal variations), \dQuote{season} to
plot variation throughout the year, \dQuote{weekday} to plot day of the
week variation and \dQuote{trend} to plot the trend by wind direction.}

\item{latitude}{The decimal latitude.}

\item{longitude}{The decimal longitude.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{type}{The grouping variable that provides a data set for a specific
location. Often, with several sites, \code{type = "site"} is used.}

\item{cols}{The colours used for plotting.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should the key of the plot be drawn. Default is \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{...}{Other arguments for \code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}.}
}
\value{
A leaflet object.
}
\description{
Polar annulus plots on interactive leaflet maps
}
\examples{
\dontrun{
annulusMap(polar_data,
  period = "hour",
  type = "site",
  provider = "Stamen.Toner"
)
}
}
