% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{decorate}
\alias{decorate}
\title{Sugar function for decoration}
\usage{
decorate(object, decorators, exists = c("skip", "error", "overwrite"), ...)
}
\arguments{
\item{object}{\verb{[R6::R6Class]} \cr R6 class to decorate.}

\item{decorators}{\verb{([DecorateClass]|character())} \cr
One or more decorators (by name or class) to decorate with.}

\item{exists}{\verb{(character(1)} \cr Expected behaviour if method exists in
\code{object} and \code{decorator}. One of: 1. \code{exists = "error"} (default) - This
will throw an error and prevent the object being decorated.
2. \code{exists = "skip"} - This will decorate the object with all fields/methods
that don't already exist. 3. \code{exists = "overwrite"} - This will decorate
the object with all fields/methods from the decorator and overwrite ones
with the same name if they already exist.}

\item{...}{\code{ANY} \cr Additional arguments passed to \link{get}.}
}
\description{
Simple wrapper around \code{decorator$new(object, exists)}
}
\examples{
library(R6)

## Define decorators
dec1 <- DecoratorClass("dec1", public = list(goodbye = "Goodbye World"))
dec2 <- DecoratorClass("dec2", public = list(goodbye2 = "Goodbye World 2"))

oop <- ooplah$new()
oop$goodbye
dec_oop <- decorate(oop, c(dec1, dec2))
dec_oop$goodbye
dec_oop$goodbye2

## Equivalently
oop <- ooplah$new()
decorate(oop, c("dec1", "dec2"))

}
\seealso{
\link{DecoratorClass}
}
