% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rls_update.R
\name{rls_update}
\alias{rls_update}
\title{Updates the model fits}
\usage{
rls_update(model, datatr = NA, y = NA, runcpp = TRUE)
}
\arguments{
\item{model}{A model object}

\item{datatr}{a data.list with transformed data (from model$transform_data(D))}

\item{y}{A vector of the model output for the corresponding time steps in \code{datatr}}

\item{runcpp}{Optional, default = TRUE. If TRUE, a c++ implementation of the update is run, otherwise a slower R implementation is used.}
}
\value{
Returns a named list for each horizon (\code{model$kseq}) containing the variables needed for the RLS fit (for each horizon, which is saved in model$Lfits):

It will update variables in the forecast model object.
}
\description{
Calculates the RLS update of the model coefficients with the provived data.
}
\details{
See vignette ??ref(recursive updating, not yet finished) on how to use the function.
}
\examples{

# See rls_predict examples

}
\seealso{
See \code{\link{rls_predict}}.
}
