% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripple_seq.R
\name{ripple_seq}
\alias{ripple_seq}
\title{Compares and displays plausible alternative orders for a given linkage
group}
\usage{
ripple_seq(input.seq, ws = 4, ext.w = NULL, LOD = 3, tol = 0.1)
}
\arguments{
\item{input.seq}{an object of class \code{sequence} with a
predefined order.}

\item{ws}{an integer specifying the length of the window size
(defaults to 4).}

\item{ext.w}{an integer specifying how many markers should be
considered in the vicinity of the permuted window. If
\code{ext.w=NULL} all markers in the sequence are
considered. In this veriosn, it is used only in backcross,
\eqn{F_2}{F_2} or RIL crosses.}

\item{LOD}{threshold for the LOD-Score, so that alternative orders
with LOD less then or equal to this threshold will be
displayed.}

\item{tol}{tolerance for the C routine, i.e., the value used to
evaluate convergence.}
}
\value{
This function does not return any value; it just produces
    text output to suggest alternative orders.
}
\description{
For a given sequence of ordered markers, computes the multipoint likelihood
of alternative orders, by shuffling subsets (windows) of markers within the
sequence. For each position of the window, all possible \eqn{(ws)!}{(ws)!}
orders are compared.
}
\details{
Large values for the window size make computations very slow, specially if
there are many partially informative markers.
}
\examples{

\dontrun{
 #Outcross example
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)
  markers <- make_seq(twopt,c(27,16,20,4,19,21,23,9,24,29))
  markers.map <- map(markers)
  ripple_seq(markers.map)

#F2 example
 data(onemap_example_f2)
 twopt <- rf_2pts(onemap_example_f2)
 all_mark <- make_seq(twopt,"all")
 groups <- group(all_mark)
 LG3 <- make_seq(groups,3)
 LG3.ord <- order_seq(LG3, subset.search = "twopt", twopt.alg = "rcd", touchdown=TRUE)
 LG3.ord
 make_seq(LG3.ord) # get safe sequence
 ord.1<-make_seq(LG3.ord,"force") # get forced sequence
 ripple_seq(ord.1, ws=5)
}

}
\references{
Broman, K. W., Wu, H., Churchill, G., Sen, S., Yandell, B.
(2008) \emph{qtl: Tools for analyzing QTL experiments} R package version
1.09-43

Jiang, C. and Zeng, Z.-B. (1997). Mapping quantitative trait loci with
dominant and missing markers in various crosses from two inbred lines.
\emph{Genetica} 101: 47-58.

Lander, E. S., Green, P., Abrahamson, J., Barlow, A., Daly, M. J., Lincoln,
S. E. and Newburg, L. (1987) MAPMAKER: An interactive computer package for
constructing primary genetic linkage maps of experimental and natural
populations. \emph{Genomics} 1: 174-181.

Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia, A. A. F.
(2009) Evaluation of algorithms used to order markers on genetics maps.
\emph{Heredity} 103: 494-502.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002a) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.

Wu, R., Ma, C.-X., Wu, S. S. and Zeng, Z.-B. (2002b). Linkage mapping of
sex-specific differences. \emph{Genetical Research} 79: 85-96
}
\seealso{
\code{\link[onemap]{make_seq}},
    \code{\link[onemap]{compare}}, \code{\link[onemap]{try_seq}}
    and \code{\link[onemap]{order_seq}}.
}
\author{
Gabriel R A Margarido, \email{gramarga@gmail.com} and
    Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{utilities}
