% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_omx.R
\name{read_omx}
\alias{read_omx}
\title{Read an OMX matrix}
\usage{
read_omx(file, name, row_index = NULL, col_index = NULL)
}
\arguments{
\item{file}{Path name of the OMX file where the matrix resides.}

\item{name}{Name of the matrix in the OMX file}

\item{row_index}{An integer vector indicating the rows represented by
\code{matrix}. Defaults to \code{NULL}, meaning that all rows are read
(and \code{nrow(matrix)} is the number of rows in the matrix).}

\item{col_index}{The precise corrolary to \code{row_index}, for columns.}
}
\value{
An R matrix object containing the named data from the OMX file
}
\description{
This function reads an entire matrix in an OMX file or portions of a matrix
using indexing.
}
\examples{
omxfile <- omxr_example("skims.omx")
mat <- read_omx(omxfile, "DIST")
str(mat)
read_omx(omxfile, "DIST", c(1,4,5), c(1,4,5))

}
